/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.sso.cas;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;

public class CASFilter
extends BasePortalFilter {
    public static String LOGIN = String.valueOf(CASFilter.class.getName()) + "LOGIN";
    private static Log _log = LogFactoryUtil.getLog(CASFilter.class);
    private static Map<Long, TicketValidator> _ticketValidators = new ConcurrentHashMap<Long, TicketValidator>();

    public static void reload(long companyId) {
        _ticketValidators.remove(companyId);
    }

    protected Log getLog() {
        return _log;
    }

    protected TicketValidator getTicketValidator(long companyId) throws Exception {
        TicketValidator ticketValidator = _ticketValidators.get(companyId);
        if (ticketValidator != null) {
            return ticketValidator;
        }
        String serverName = PrefsPropsUtil.getString(companyId, "cas.server.name", PropsValues.CAS_SERVER_NAME);
        String serverUrl = PrefsPropsUtil.getString(companyId, "cas.server.url", PropsValues.CAS_SERVER_URL);
        String loginUrl = PrefsPropsUtil.getString(companyId, "cas.login.url", PropsValues.CAS_LOGIN_URL);
        Cas20ProxyTicketValidator cas20ProxyTicketValidator = new Cas20ProxyTicketValidator(serverUrl);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverName", serverName);
        parameters.put("casServerUrlPrefix", serverUrl);
        parameters.put("casServerLoginUrl", loginUrl);
        parameters.put("redirectAfterValidation", "false");
        cas20ProxyTicketValidator.setCustomParameters(parameters);
        _ticketValidators.put(companyId, (TicketValidator)cas20ProxyTicketValidator);
        return cas20ProxyTicketValidator;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        if (PrefsPropsUtil.getBoolean(companyId, "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED)) {
            String ticket;
            HttpSession session = request.getSession();
            String pathInfo = request.getPathInfo();
            if (pathInfo.indexOf("/portal/logout") != -1) {
                session.invalidate();
                String logoutUrl = PrefsPropsUtil.getString(companyId, "cas.logout.url", PropsValues.CAS_LOGOUT_URL);
                response.sendRedirect(logoutUrl);
                return;
            }
            String login = (String)session.getAttribute(LOGIN);
            String serverName = PrefsPropsUtil.getString(companyId, "cas.server.name", PropsValues.CAS_SERVER_NAME);
            String serviceUrl = PrefsPropsUtil.getString(companyId, "cas.service.url", PropsValues.CAS_SERVICE_URL);
            if (Validator.isNull((String)serviceUrl)) {
                serviceUrl = CommonUtils.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)serviceUrl, (String)serverName, (String)"ticket", (boolean)false);
            }
            if (Validator.isNull((String)(ticket = ParamUtil.getString((HttpServletRequest)request, (String)"ticket")))) {
                if (Validator.isNotNull((String)login)) {
                    this.processFilter(CASFilter.class, request, response, filterChain);
                } else {
                    String loginUrl = PrefsPropsUtil.getString(companyId, "cas.login.url", PropsValues.CAS_LOGIN_URL);
                    loginUrl = HttpUtil.addParameter((String)loginUrl, (String)"service", (String)serviceUrl);
                    response.sendRedirect(loginUrl);
                }
                return;
            }
            TicketValidator ticketValidator = this.getTicketValidator(companyId);
            Assertion assertion = ticketValidator.validate(ticket, serviceUrl);
            if (assertion != null) {
                AttributePrincipal attributePrincipal = assertion.getPrincipal();
                login = attributePrincipal.getName();
                session.setAttribute(LOGIN, (Object)login);
            }
        }
        this.processFilter(CASFilter.class, request, response, filterChain);
    }
}

