/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.etag;

import com.liferay.portal.kernel.servlet.ByteBufferServletResponse;
import java.nio.ByteBuffer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ETagUtil {
    public static boolean processETag(HttpServletRequest request, HttpServletResponse response, byte[] bytes) {
        return ETagUtil._processETag(request, response, ETagUtil._hashCode(bytes, 0, bytes.length));
    }

    public static boolean processETag(HttpServletRequest request, HttpServletResponse response, byte[] bytes, int length) {
        return ETagUtil._processETag(request, response, ETagUtil._hashCode(bytes, 0, length));
    }

    public static boolean processETag(HttpServletRequest request, HttpServletResponse response, byte[] bytes, int offset, int length) {
        return ETagUtil._processETag(request, response, ETagUtil._hashCode(bytes, offset, length));
    }

    public static boolean processETag(HttpServletRequest request, HttpServletResponse response, String s) {
        return ETagUtil._processETag(request, response, s.hashCode());
    }

    public static boolean processETag(HttpServletRequest request, HttpServletResponse response, ByteBufferServletResponse byteBufferResponse) {
        ByteBuffer byteBuffer = byteBufferResponse.getByteBuffer();
        return ETagUtil.processETag(request, response, byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
    }

    private static int _hashCode(byte[] data, int offset, int length) {
        int hashCode = 0;
        int i = 0;
        while (i < length) {
            hashCode = 31 * hashCode + data[offset++];
            ++i;
        }
        return hashCode;
    }

    private static boolean _processETag(HttpServletRequest request, HttpServletResponse response, int hashCode) {
        String eTag = "\"".concat(Integer.toHexString(hashCode)).concat("\"");
        response.setHeader("ETag", eTag);
        String ifNoneMatch = request.getHeader("If-None-Match");
        if (eTag.equals(ifNoneMatch)) {
            response.setStatus(304);
            response.setContentLength(0);
            return true;
        }
        return false;
    }
}

