/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicateOrganizationException;
import com.liferay.portal.OrganizationNameException;
import com.liferay.portal.OrganizationParentException;
import com.liferay.portal.OrganizationTypeException;
import com.liferay.portal.RequiredOrganizationException;
import com.liferay.portal.kernel.cache.ThreadLocalCachable;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.ListTypeConstants;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.OrganizationImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.OrganizationLocalServiceBaseImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.OrganizationNameComparator;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationLocalServiceImpl
extends OrganizationLocalServiceBaseImpl {
    public void addGroupOrganizations(long groupId, long[] organizationIds) throws PortalException, SystemException {
        this.groupPersistence.addOrganizations(groupId, organizationIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(Organization.class);
        indexer.reindex((Object)organizationIds);
        PermissionCacheUtil.clearCache();
    }

    public Organization addOrganization(long userId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        parentOrganizationId = this.getParentOrganizationId(user.getCompanyId(), parentOrganizationId);
        recursable = true;
        this.validate(user.getCompanyId(), parentOrganizationId, name, type, countryId, statusId);
        long organizationId = this.counterLocalService.increment();
        Organization organization = this.organizationPersistence.create(organizationId);
        organization.setCompanyId(user.getCompanyId());
        organization.setParentOrganizationId(parentOrganizationId);
        organization.setName(name);
        organization.setType(type);
        organization.setRecursable(recursable);
        organization.setRegionId(regionId);
        organization.setCountryId(countryId);
        organization.setStatusId(statusId);
        organization.setComments(comments);
        this.organizationPersistence.update((BaseModel)organization, false);
        Group group = this.groupLocalService.addGroup(userId, Organization.class.getName(), organizationId, null, null, 0, null, true, null);
        if (PropsValues.ORGANIZATIONS_ASSIGNMENT_AUTO) {
            Role role = this.roleLocalService.getRole(organization.getCompanyId(), "Organization Owner");
            this.userGroupRoleLocalService.addUserGroupRoles(userId, group.getGroupId(), new long[]{role.getRoleId()});
            this.userPersistence.addOrganization(userId, organizationId);
        }
        this.addOrganizationResources(userId, organization);
        if (serviceContext != null) {
            this.updateAsset(userId, organization, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        ExpandoBridge expandoBridge = organization.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        Indexer indexer = IndexerRegistryUtil.getIndexer(Organization.class);
        indexer.reindex((Object)organization);
        return organization;
    }

    public void addOrganizationResources(long userId, Organization organization) throws PortalException, SystemException {
        String name = Organization.class.getName();
        this.resourceLocalService.addResources(organization.getCompanyId(), 0L, userId, name, organization.getOrganizationId(), false, false, false);
    }

    public void addPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws SystemException {
        this.passwordPolicyRelLocalService.addPasswordPolicyRels(passwordPolicyId, Organization.class.getName(), organizationIds);
    }

    public void deleteLogo(long organizationId) throws PortalException, SystemException {
        LayoutSet privateLayoutSet;
        Organization organization = this.getOrganization(organizationId);
        Group group = organization.getGroup();
        LayoutSet publicLayoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), false);
        if (publicLayoutSet.isLogo()) {
            long logoId = publicLayoutSet.getLogoId();
            publicLayoutSet.setLogo(false);
            publicLayoutSet.setLogoId(0L);
            this.layoutSetPersistence.update((BaseModel)publicLayoutSet, false);
            this.imageLocalService.deleteImage(logoId);
        }
        if ((privateLayoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), true)).isLogo()) {
            long logoId = privateLayoutSet.getLogoId();
            privateLayoutSet.setLogo(false);
            privateLayoutSet.setLogoId(0L);
            this.layoutSetPersistence.update((BaseModel)publicLayoutSet, false);
            if (this.imageLocalService.getImage(logoId) != null) {
                this.imageLocalService.deleteImage(logoId);
            }
        }
    }

    @Override
    public void deleteOrganization(long organizationId) throws PortalException, SystemException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        if (this.userLocalService.getOrganizationUsersCount(organization.getOrganizationId(), true) > 0 || this.organizationPersistence.countByC_P(organization.getCompanyId(), organization.getOrganizationId()) > 0) {
            throw new RequiredOrganizationException();
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer(Organization.class);
        indexer.delete((Object)organization);
        this.assetEntryLocalService.deleteEntry(Organization.class.getName(), organization.getOrganizationId());
        this.addressLocalService.deleteAddresses(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this.emailAddressLocalService.deleteEmailAddresses(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this.expandoValueLocalService.deleteValues(Organization.class.getName(), organization.getOrganizationId());
        this.passwordPolicyRelLocalService.deletePasswordPolicyRel(Organization.class.getName(), organization.getOrganizationId());
        this.phoneLocalService.deletePhones(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this.websiteLocalService.deleteWebsites(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        Group group = organization.getGroup();
        this.groupLocalService.deleteGroup(group.getGroupId());
        String name = Organization.class.getName();
        this.resourceLocalService.deleteResource(organization.getCompanyId(), name, 4, organization.getOrganizationId());
        this.organizationPersistence.remove((BaseModel)organization);
        PermissionCacheUtil.clearCache();
    }

    public List<Organization> getGroupOrganizations(long groupId) throws SystemException {
        return this.groupPersistence.getOrganizations(groupId);
    }

    @Override
    public Organization getOrganization(long organizationId) throws PortalException, SystemException {
        return this.organizationPersistence.findByPrimaryKey(organizationId);
    }

    public Organization getOrganization(long companyId, String name) throws PortalException, SystemException {
        return this.organizationPersistence.findByC_N(companyId, name);
    }

    public long getOrganizationId(long companyId, String name) throws SystemException {
        Organization organization = this.organizationPersistence.fetchByC_N(companyId, name);
        if (organization != null) {
            return organization.getOrganizationId();
        }
        return 0L;
    }

    public List<Organization> getOrganizations(long[] organizationIds) throws PortalException, SystemException {
        ArrayList<Organization> organizations = new ArrayList<Organization>(organizationIds.length);
        long[] lArray = organizationIds;
        int n = organizationIds.length;
        int n2 = 0;
        while (n2 < n) {
            long organizationId = lArray[n2];
            Organization organization = this.getOrganization(organizationId);
            organizations.add(organization);
            ++n2;
        }
        return organizations;
    }

    public List<Organization> getParentOrganizations(long organizationId) throws PortalException, SystemException {
        if (organizationId == 0L) {
            return new ArrayList<Organization>();
        }
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        return this.getParentOrganizations(organization, true);
    }

    public List<Organization> getSuborganizations(List<Organization> organizations) throws SystemException {
        ArrayList<Organization> allSuborganizations = new ArrayList<Organization>();
        int i = 0;
        while (i < organizations.size()) {
            Organization organization = organizations.get(i);
            List suborganizations = this.organizationPersistence.findByC_P(organization.getCompanyId(), organization.getOrganizationId());
            this.addSuborganizations(allSuborganizations, suborganizations);
            ++i;
        }
        return allSuborganizations;
    }

    public List<Organization> getSubsetOrganizations(List<Organization> allOrganizations, List<Organization> availableOrganizations) {
        ArrayList<Organization> subsetOrganizations = new ArrayList<Organization>();
        for (Organization organization : allOrganizations) {
            if (!availableOrganizations.contains(organization)) continue;
            subsetOrganizations.add(organization);
        }
        return subsetOrganizations;
    }

    public List<Organization> getUserOrganizations(long userId) throws PortalException, SystemException {
        return this.getUserOrganizations(userId, false);
    }

    public List<Organization> getUserOrganizations(long userId, boolean inheritUserGroups) throws PortalException, SystemException {
        return this.getUserOrganizations(userId, inheritUserGroups, -1, -1);
    }

    public List<Organization> getUserOrganizations(long userId, boolean inheritUserGroups, int start, int end) throws PortalException, SystemException {
        if (inheritUserGroups && PropsValues.ORGANIZATIONS_USER_GROUP_MEMBERSHIP_ENABLED) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            LinkedHashMap<String, Object> organizationParams = new LinkedHashMap<String, Object>();
            organizationParams.put("usersOrgs", new Long(userId));
            return this.search(user.getCompanyId(), -1L, null, null, null, null, organizationParams, start, end);
        }
        return this.userPersistence.getOrganizations(userId, start, end);
    }

    public List<Organization> getUserOrganizations(long userId, int start, int end) throws PortalException, SystemException {
        return this.getUserOrganizations(userId, false, start, end);
    }

    @ThreadLocalCachable
    public int getUserOrganizationsCount(long userId) throws SystemException {
        return this.userPersistence.getOrganizationsSize(userId);
    }

    public boolean hasGroupOrganization(long groupId, long organizationId) throws SystemException {
        return this.groupPersistence.containsOrganization(groupId, organizationId);
    }

    public boolean hasPasswordPolicyOrganization(long passwordPolicyId, long organizationId) throws SystemException {
        return this.passwordPolicyRelLocalService.hasPasswordPolicyRel(passwordPolicyId, Organization.class.getName(), organizationId);
    }

    public boolean hasUserOrganization(long userId, long organizationId) throws SystemException {
        return this.userPersistence.containsOrganization(userId, organizationId);
    }

    public boolean hasUserOrganization(long userId, long organizationId, boolean inheritSuborganizations, boolean inheritUserGroups, boolean includeSpecifiedOrganization) throws PortalException, SystemException {
        if (!inheritSuborganizations && !inheritUserGroups) {
            return this.userPersistence.containsOrganization(userId, organizationId);
        }
        if (inheritSuborganizations) {
            LinkedHashMap<String, Long[][]> params = new LinkedHashMap<String, Long[][]>();
            Long[][] leftAndRightOrganizationIds = EnterpriseAdminUtil.getLeftAndRightOrganizationIds((long)organizationId);
            if (!includeSpecifiedOrganization) {
                leftAndRightOrganizationIds[0][0] = leftAndRightOrganizationIds[0][0] + 1L;
            }
            params.put("usersOrgsTree", leftAndRightOrganizationIds);
            if (this.userFinder.countByUser(userId, params) > 0) {
                return true;
            }
        }
        return inheritUserGroups && this.organizationFinder.countByO_U(organizationId, userId) > 0;
    }

    public void rebuildTree(long companyId, boolean force) throws SystemException {
        this.organizationPersistence.rebuildTree(companyId, force);
    }

    public Hits search(long companyId, long parentOrganizationId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws SystemException {
        String name = null;
        String type = null;
        String street = null;
        String city = null;
        String zip = null;
        String region = null;
        String country = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            name = keywords;
            type = keywords;
            street = keywords;
            city = keywords;
            zip = keywords;
            region = keywords;
            country = keywords;
        } else {
            andOperator = true;
        }
        return this.search(companyId, parentOrganizationId, name, type, street, city, zip, region, country, params, andOperator, start, end, sort);
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params, int start, int end) throws SystemException {
        return this.search(companyId, parentOrganizationId, keywords, type, regionId, countryId, params, start, end, (OrderByComparator)new OrganizationNameComparator(true));
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.findByKeywords(companyId, parentOrganizationId, parentOrganizationIdComparator, keywords, type, regionId, countryId, params, start, end, obc);
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) throws SystemException {
        return this.search(companyId, parentOrganizationId, name, type, street, city, zip, regionId, countryId, params, andOperator, start, end, (OrderByComparator)new OrganizationNameComparator(true));
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.findByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, name, type, street, city, zip, regionId, countryId, params, andOperator, start, end, obc);
    }

    public Hits search(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, String region, String country, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws SystemException {
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("city", city);
            attributes.put("country", country);
            attributes.put("name", name);
            attributes.put("params", params);
            if (parentOrganizationId > 0L) {
                attributes.put("parentOrganizationId", String.valueOf(parentOrganizationId));
            }
            attributes.put("region", region);
            attributes.put("street", street);
            attributes.put("type", type);
            attributes.put("zip", zip);
            SearchContext searchContext = new SearchContext();
            searchContext.setAndSearch(andSearch);
            searchContext.setAttributes(attributes);
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setSorts(new Sort[]{sort});
            searchContext.setStart(start);
            Indexer indexer = IndexerRegistryUtil.getIndexer(Organization.class);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public int searchCount(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params) throws SystemException {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.countByKeywords(companyId, parentOrganizationId, parentOrganizationIdComparator, keywords, type, regionId, countryId, params);
    }

    public int searchCount(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.countByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, name, type, street, city, zip, regionId, countryId, params, andOperator);
    }

    public void setGroupOrganizations(long groupId, long[] organizationIds) throws PortalException, SystemException {
        this.groupPersistence.setOrganizations(groupId, organizationIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(Organization.class);
        indexer.reindex((Object)organizationIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetGroupOrganizations(long groupId, long[] organizationIds) throws PortalException, SystemException {
        this.groupPersistence.removeOrganizations(groupId, organizationIds);
        Indexer indexer = IndexerRegistryUtil.getIndexer(Organization.class);
        indexer.reindex((Object)organizationIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws SystemException {
        this.passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicyId, Organization.class.getName(), organizationIds);
    }

    public void updateAsset(long userId, Organization organization, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        Group companyGroup = company.getGroup();
        this.assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), Organization.class.getName(), organization.getOrganizationId(), null, assetCategoryIds, assetTagNames, false, null, null, null, null, null, organization.getName(), "", null, null, 0, 0, null, false);
    }

    public Organization updateOrganization(long companyId, long organizationId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        parentOrganizationId = this.getParentOrganizationId(companyId, parentOrganizationId);
        recursable = true;
        this.validate(companyId, organizationId, parentOrganizationId, name, type, countryId, statusId);
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        organization.setParentOrganizationId(parentOrganizationId);
        organization.setName(name);
        organization.setType(type);
        organization.setRecursable(recursable);
        organization.setRegionId(regionId);
        organization.setCountryId(countryId);
        organization.setStatusId(statusId);
        organization.setComments(comments);
        this.organizationPersistence.update((BaseModel)organization, false);
        if (serviceContext != null) {
            this.updateAsset(serviceContext.getUserId(), organization, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        ExpandoBridge expandoBridge = organization.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        Indexer indexer = IndexerRegistryUtil.getIndexer(Organization.class);
        indexer.reindex((Object)organization);
        return organization;
    }

    protected void addSuborganizations(List<Organization> allSuborganizations, List<Organization> organizations) throws SystemException {
        for (Organization organization : organizations) {
            if (allSuborganizations.contains(organization)) continue;
            allSuborganizations.add(organization);
            List suborganizations = this.organizationPersistence.findByC_P(organization.getCompanyId(), organization.getOrganizationId());
            this.addSuborganizations(allSuborganizations, suborganizations);
        }
    }

    protected long getParentOrganizationId(long companyId, long parentOrganizationId) throws SystemException {
        Organization parentOrganization;
        if (parentOrganizationId != 0L && ((parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId)) == null || companyId != parentOrganization.getCompanyId())) {
            parentOrganizationId = 0L;
        }
        return parentOrganizationId;
    }

    protected List<Organization> getParentOrganizations(Organization organization, boolean lastOrganization) throws PortalException, SystemException {
        long parentOrganizationId;
        ArrayList<Organization> organizations = new ArrayList<Organization>();
        if (!lastOrganization) {
            organizations.add(organization);
        }
        if ((parentOrganizationId = organization.getParentOrganizationId()) == 0L) {
            return organizations;
        }
        Organization parentOrganization = this.organizationPersistence.findByPrimaryKey(parentOrganizationId);
        List<Organization> parentOrganizatons = this.getParentOrganizations(parentOrganization, false);
        organizations.addAll(parentOrganizatons);
        return organizations;
    }

    protected boolean isParentOrganization(long parentOrganizationId, long organizationId) throws PortalException, SystemException {
        Organization parentOrganization = this.organizationPersistence.findByPrimaryKey(parentOrganizationId);
        List<Organization> parentOrganizations = this.getParentOrganizations(organizationId);
        return parentOrganizations.contains(parentOrganization);
    }

    protected void validate(long companyId, long organizationId, long parentOrganizationId, String name, String type, long countryId, int statusId) throws PortalException, SystemException {
        if (!ArrayUtil.contains((Object[])PropsValues.ORGANIZATIONS_TYPES, (Object)type)) {
            throw new OrganizationTypeException("Invalid organization type " + type);
        }
        if (parentOrganizationId == 0L) {
            if (!OrganizationImpl.isRootable(type)) {
                throw new OrganizationParentException("Organization of type " + type + " cannot be a root");
            }
        } else {
            Organization parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId);
            if (parentOrganization == null) {
                throw new OrganizationParentException("Organization " + parentOrganizationId + " doesn't exist");
            }
            Object[] childrenTypes = OrganizationImpl.getChildrenTypes(parentOrganization.getType());
            if (childrenTypes.length == 0) {
                throw new OrganizationParentException("Organization of type " + type + " cannot have children");
            }
            if (companyId != parentOrganization.getCompanyId() || parentOrganizationId == organizationId) {
                throw new OrganizationParentException();
            }
            if (!ArrayUtil.contains((Object[])childrenTypes, (Object)type)) {
                throw new OrganizationParentException("Type " + type + " not allowed as child of " + parentOrganization.getType());
            }
        }
        if (organizationId > 0L && parentOrganizationId != 0L && this.isParentOrganization(organizationId, parentOrganizationId)) {
            throw new OrganizationParentException();
        }
        if (Validator.isNull((String)name)) {
            throw new OrganizationNameException();
        }
        Organization organization = this.organizationPersistence.fetchByC_N(companyId, name);
        if (organization != null && organization.getName().equalsIgnoreCase(name) && (organizationId <= 0L || organization.getOrganizationId() != organizationId)) {
            throw new DuplicateOrganizationException();
        }
        boolean countryRequired = GetterUtil.getBoolean((String)PropsUtil.get("organizations.country.required", new Filter(type)));
        if (countryRequired || countryId > 0L) {
            this.countryPersistence.findByPrimaryKey(countryId);
        }
        this.listTypeService.validate(statusId, ListTypeConstants.ORGANIZATION_STATUS);
    }

    protected void validate(long companyId, long parentOrganizationId, String name, String type, long countryId, int statusId) throws PortalException, SystemException {
        this.validate(companyId, 0L, parentOrganizationId, name, type, countryId, statusId);
    }
}

