/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.servlet.filters.sso.cas.CASFilter;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CASAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(CASAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) {
        String[] credentials = null;
        try {
            String redirect;
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            if (!PrefsPropsUtil.getBoolean(companyId, "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED)) {
                return credentials;
            }
            HttpSession session = request.getSession();
            String login = (String)session.getAttribute(CASFilter.LOGIN);
            if (Validator.isNull((String)login)) {
                return credentials;
            }
            String authType = PrefsPropsUtil.getString(companyId, "company.security.auth.type", PropsValues.COMPANY_SECURITY_AUTH_TYPE);
            User user = null;
            if (PrefsPropsUtil.getBoolean(companyId, "cas.import.from.ldap", PropsValues.CAS_IMPORT_FROM_LDAP)) {
                try {
                    user = authType.equals("screenName") ? this.importLDAPUser(companyId, "", login) : this.importLDAPUser(companyId, login, "");
                }
                catch (SystemException systemException) {}
            }
            if (user == null) {
                user = authType.equals("screenName") ? UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)login) : UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)login);
            }
            if (Validator.isNotNull((String)(redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect")))) {
                request.setAttribute("AUTO_LOGIN_REDIRECT", (Object)redirect);
            }
            credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
            return credentials;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return credentials;
        }
    }

    protected User addUser(long companyId, String screenName) throws Exception {
        return this.importLDAPUser(companyId, "", screenName);
    }

    protected User importLDAPUser(long ldapServerId, long companyId, String emailAddress, String screenName) throws Exception {
        Context ldapContext = null;
        try {
            String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
            String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
            ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
            if (ldapContext == null) {
                throw new SystemException("Failed to bind to the LDAP server");
            }
            String filter = PrefsPropsUtil.getString(companyId, "ldap.auth.search.filter" + postfix);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search filter before transformation " + filter));
            }
            filter = StringUtil.replace((String)filter, (String[])new String[]{"@company_id@", "@email_address@", "@screen_name@"}, (String[])new String[]{String.valueOf(companyId), emailAddress, screenName});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search filter after transformation " + filter));
            }
            Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty("screenName")).toLowerCase();
            SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
            NamingEnumeration<SearchResult> enu = ldapContext.search(baseDN, filter, searchControls);
            if (enu.hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter returned at least one result");
                }
                Binding binding = (Binding)enu.nextElement();
                Attributes attributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, (LdapContext)ldapContext, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding));
                User user = PortalLDAPImporterUtil.importLDAPUser(ldapServerId, companyId, (LdapContext)ldapContext, attributes, "");
                return user;
            }
            return null;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Problem accessing LDAP server " + e.getMessage()));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            throw new SystemException("Problem accessing LDAP server " + e.getMessage());
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    protected User importLDAPUser(long companyId, String emailAddress, String screenName) throws Exception {
        long[] ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L);
        if (ldapServerIds.length <= 0) {
            ldapServerIds = new long[1];
        }
        long[] lArray = ldapServerIds;
        int n = ldapServerIds.length;
        int n2 = 0;
        while (n2 < n) {
            long ldapServerId = lArray[n2];
            User user = this.importLDAPUser(ldapServerId, companyId, emailAddress, screenName);
            if (user != null) {
                return user;
            }
            ++n2;
        }
        if (_log.isDebugEnabled()) {
            if (Validator.isNotNull((String)emailAddress)) {
                _log.debug((Object)("User with the email address " + emailAddress + " was not found in any LDAP servers"));
            } else {
                _log.debug((Object)("User with the screen name " + screenName + " was not found in any LDAP servers"));
            }
        }
        return null;
    }
}

