/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionExporter;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.lar.PortletExporter;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Theme;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.servlet.ServletContext;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutExporter {
    public static final String SAME_GROUP_FRIENDLY_URL = "/[$SAME_GROUP_FRIENDLY_URL$]";
    private static Log _log = LogFactoryUtil.getLog(LayoutExporter.class);
    private PermissionExporter _permissionExporter = new PermissionExporter();
    private PortletExporter _portletExporter = new PortletExporter();

    public static List<Portlet> getAlwaysExportablePortlets(long companyId) throws Exception {
        List portlets = PortletLocalServiceUtil.getPortlets((long)companyId);
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            if (!portlet.isActive()) {
                itr.remove();
                continue;
            }
            PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
            if (portletDataHandler != null && portletDataHandler.isAlwaysExportable()) continue;
            itr.remove();
        }
        return portlets;
    }

    public static void updateLastPublishDate(LayoutSet layoutSet, long lastPublishDate) throws Exception {
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        if (lastPublishDate <= 0L) {
            settingsProperties.remove((Object)"last-publish-date");
        } else {
            settingsProperties.setProperty("last-publish-date", String.valueOf(lastPublishDate));
        }
        LayoutSetLocalServiceUtil.updateSettings((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (String)settingsProperties.toString());
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        File file = this.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        finally {
            file.delete();
        }
    }

    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        boolean exportCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean exportIgnoreLastPublishDate = MapUtil.getBoolean(parameterMap, (String)"IGNORE_LAST_PUBLISH_DATE");
        boolean exportPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean exportUserPermissions = MapUtil.getBoolean(parameterMap, (String)"USER_PERMISSIONS");
        boolean exportPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean exportPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        boolean exportTheme = MapUtil.getBoolean(parameterMap, (String)"THEME");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export categories " + exportCategories));
            _log.debug((Object)("Export permissions " + exportPermissions));
            _log.debug((Object)("Export user permissions " + exportUserPermissions));
            _log.debug((Object)("Export portlet archived setups " + exportPortletArchivedSetups));
            _log.debug((Object)("Export portlet user preferences " + exportPortletUserPreferences));
            _log.debug((Object)("Export theme " + exportTheme));
        }
        long lastPublishDate = System.currentTimeMillis();
        if (endDate != null) {
            lastPublishDate = endDate.getTime();
        }
        if (exportIgnoreLastPublishDate) {
            endDate = null;
            startDate = null;
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        LayoutCache layoutCache = new LayoutCache();
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        PortletDataContextImpl context = new PortletDataContextImpl(companyId, groupId, parameterMap, new HashSet<String>(), startDate, endDate, zipWriter);
        context.setPortetDataContextListener(new PortletDataContextListenerImpl(context));
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (context.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(context.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(context.getEndDate()));
        }
        headerElement.addAttribute("type", "layout-set");
        headerElement.addAttribute("group-id", String.valueOf(groupId));
        headerElement.addAttribute("private-layout", String.valueOf(privateLayout));
        headerElement.addAttribute("theme-id", layoutSet.getThemeId());
        headerElement.addAttribute("color-scheme-id", layoutSet.getColorSchemeId());
        Portlet layoutConfigurationPortlet = PortletLocalServiceUtil.getPortletById((long)context.getCompanyId(), (String)"87");
        LinkedHashMap<String, Object[]> portletIds = new LinkedHashMap<String, Object[]>();
        List layouts = null;
        layouts = layoutIds == null || layoutIds.length == 0 ? LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout) : LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long[])layoutIds);
        Layout firstLayout = (Layout)layouts.get(0);
        List<Portlet> portlets = LayoutExporter.getAlwaysExportablePortlets(companyId);
        for (Portlet portlet : portlets) {
            String key;
            String portletId = portlet.getRootPortletId();
            if (portlet.isScopeable() && firstLayout.hasScopeGroup()) {
                key = PortletPermissionUtil.getPrimaryKey((long)firstLayout.getPlid(), (String)portletId);
                portletIds.put(key, new Object[]{portletId, firstLayout.getPlid(), firstLayout.getScopeGroup().getGroupId(), firstLayout.getUuid()});
                continue;
            }
            key = PortletPermissionUtil.getPrimaryKey((long)0L, (String)portletId);
            if (portletIds.get(key) != null) continue;
            portletIds.put(key, new Object[]{portletId, firstLayout.getPlid(), groupId, ""});
        }
        Element layoutsElement = rootElement.addElement("layouts");
        for (Layout layout : layouts) {
            this.exportLayout(context, layoutConfigurationPortlet, layoutCache, portletIds, exportPermissions, exportUserPermissions, layout, layoutsElement);
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 5) {
            Element rolesElement = rootElement.addElement("roles");
            if (exportPermissions) {
                this._permissionExporter.exportLayoutRoles(layoutCache, companyId, groupId, rolesElement);
            }
        }
        long previousScopeGroupId = context.getScopeGroupId();
        Element portletsElement = rootElement.addElement("portlets");
        for (Map.Entry portletIdsEntry : portletIds.entrySet()) {
            String portletId = (String)((Object[])portletIdsEntry.getValue())[0];
            long plid = (Long)((Object[])portletIdsEntry.getValue())[1];
            long scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
            String scopeLayoutUuid = (String)((Object[])portletIdsEntry.getValue())[3];
            Layout layout = LayoutUtil.findByPrimaryKey((long)plid);
            context.setPlid(layout.getPlid());
            context.setOldPlid(layout.getPlid());
            context.setScopeGroupId(scopeGroupId);
            context.setScopeLayoutUuid(scopeLayoutUuid);
            boolean[] exportPortletControls = this.getExportPortletControls(companyId, portletId, context, parameterMap);
            this._portletExporter.exportPortlet(context, layoutCache, portletId, layout, portletsElement, defaultUserId, exportPermissions, exportPortletArchivedSetups, exportPortletControls[0], exportPortletControls[1], exportPortletUserPreferences, exportUserPermissions);
        }
        context.setScopeGroupId(previousScopeGroupId);
        if (exportCategories) {
            this.exportCategories(context);
        }
        this._portletExporter.exportComments(context, rootElement);
        this._portletExporter.exportLocks(context, rootElement);
        if (exportPermissions) {
            this._permissionExporter.exportPortletDataPermissions(context);
        }
        this._portletExporter.exportRatings(context, rootElement);
        this._portletExporter.exportTags(context, rootElement);
        if (exportTheme) {
            this.exportTheme(layoutSet, zipWriter);
        }
        if (_log.isInfoEnabled()) {
            if (stopWatch != null) {
                _log.info((Object)("Exporting layouts takes " + stopWatch.getTime() + " ms"));
            } else {
                _log.info((Object)"Exporting layouts is finished");
            }
        }
        context.addZipEntry("/manifest.xml", document.formattedString());
        try {
            File file = zipWriter.getFile();
            return file;
        }
        finally {
            LayoutExporter.updateLastPublishDate(layoutSet, lastPublishDate);
        }
    }

    protected void exportCategories(PortletDataContext context) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("categories-hierarchy");
        Element vocabulariesElement = rootElement.addElement("vocabularies");
        List assetVocabularies = AssetVocabularyLocalServiceUtil.getGroupVocabularies((long)context.getGroupId());
        for (AssetVocabulary assetVocabulary : assetVocabularies) {
            this._portletExporter.exportVocabulary(context, vocabulariesElement, assetVocabulary);
        }
        Element categoriesElement = rootElement.addElement("categories");
        List assetCategories = AssetCategoryUtil.findByGroupId((long)context.getGroupId());
        for (AssetCategory assetCategory : assetCategories) {
            this._portletExporter.exportCategory(context, vocabulariesElement, categoriesElement, assetCategory);
        }
        this._portletExporter.exportCategories(context, rootElement);
        context.addZipEntry(String.valueOf(context.getRootPath()) + "/categories-hierarchy.xml", document.formattedString());
    }

    protected void exportLayout(PortletDataContext context, Portlet layoutConfigurationPortlet, LayoutCache layoutCache, Map<String, Object[]> portletIds, boolean exportPermissions, boolean exportUserPermissions, Layout layout, Element layoutsElement) throws Exception {
        UnicodeProperties typeSettingsProperties;
        long linkToLayoutId;
        Image image;
        String path = String.valueOf(context.getLayoutPath(layout.getLayoutId())) + "/layout.xml";
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element layoutElement = layoutsElement.addElement("layout");
        layoutElement.addAttribute("layout-uuid", layout.getUuid());
        layoutElement.addAttribute("layout-id", String.valueOf(layout.getLayoutId()));
        boolean deleteLayout = MapUtil.getBoolean((Map)context.getParameterMap(), (String)("delete_" + layout.getPlid()));
        if (deleteLayout) {
            layoutElement.addAttribute("delete", String.valueOf(true));
            return;
        }
        context.setPlid(layout.getPlid());
        if (layout.isIconImage() && (image = ImageLocalServiceUtil.getImage((long)layout.getIconImageId())) != null) {
            String iconPath = this.getLayoutIconPath(context, layout, image);
            layoutElement.addElement("icon-image-path").addText(iconPath);
            context.addZipEntry(iconPath, image.getTextObj());
        }
        this._portletExporter.exportPortletData(context, layoutConfigurationPortlet, layout, null, layoutElement);
        if (exportPermissions) {
            this._permissionExporter.exportLayoutPermissions(context, layoutCache, context.getCompanyId(), context.getScopeGroupId(), layout, layoutElement, exportUserPermissions);
        }
        if (layout.isTypePortlet()) {
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            for (String portletId : layoutTypePortlet.getPortletIds()) {
                Layout scopeLayout;
                Group scopeGroup;
                PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                String scopeLayoutUuid = GetterUtil.getString((String)jxPreferences.getValue("lfr-scope-layout-uuid", null));
                long scopeGroupId = context.getScopeGroupId();
                if (Validator.isNotNull((String)scopeLayoutUuid) && (scopeGroup = (scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)scopeGroupId)).getScopeGroup()) != null) {
                    scopeGroupId = scopeGroup.getGroupId();
                }
                String key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
                portletIds.put(key, new Object[]{portletId, layout.getPlid(), scopeGroupId, scopeLayoutUuid});
            }
        } else if (layout.isTypeLinkToLayout() && (linkToLayoutId = GetterUtil.getLong((String)(typeSettingsProperties = layout.getTypeSettingsProperties()).getProperty("linkToLayoutId", ""))) > 0L) {
            try {
                Layout linkedToLayout = LayoutUtil.findByG_P_L((long)context.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)linkToLayoutId);
                this.exportLayout(context, layoutConfigurationPortlet, layoutCache, portletIds, exportPermissions, exportUserPermissions, linkedToLayout, layoutsElement);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        }
        this.fixTypeSettings(layout);
        layoutElement.addAttribute("path", path);
        context.addZipEntry(path, (Object)layout);
    }

    protected void exportTheme(LayoutSet layoutSet, ZipWriter zipWriter) throws Exception {
        Theme theme = layoutSet.getTheme();
        String lookAndFeelXML = ContentUtil.get("com/liferay/portal/dependencies/liferay-look-and-feel.xml.tmpl");
        lookAndFeelXML = StringUtil.replace((String)lookAndFeelXML, (String[])new String[]{"[$TEMPLATE_EXTENSION$]", "[$VIRTUAL_PATH$]"}, (String[])new String[]{theme.getTemplateExtension(), theme.getVirtualPath()});
        String servletContextName = theme.getServletContextName();
        ServletContext servletContext = ServletContextPool.get((String)servletContextName);
        if (servletContext == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Servlet context not found for theme " + theme.getThemeId()));
            }
            return;
        }
        File themeZip = new File(String.valueOf(zipWriter.getPath()) + "/theme.zip");
        ZipWriter themeZipWriter = ZipWriterFactoryUtil.getZipWriter((File)themeZip);
        themeZipWriter.addEntry("liferay-look-and-feel.xml", lookAndFeelXML);
        File cssPath = null;
        File imagesPath = null;
        File javaScriptPath = null;
        File templatesPath = null;
        if (!theme.isLoadFromServletContext()) {
            ThemeLoader themeLoader = ThemeLoaderFactory.getThemeLoader(servletContextName);
            if (themeLoader == null) {
                _log.error((Object)(String.valueOf(servletContextName) + " does not map to a theme loader"));
            } else {
                String realPath = String.valueOf(themeLoader.getFileStorage().getPath()) + "/" + theme.getName();
                cssPath = new File(String.valueOf(realPath) + "/css");
                imagesPath = new File(String.valueOf(realPath) + "/images");
                javaScriptPath = new File(String.valueOf(realPath) + "/javascript");
                templatesPath = new File(String.valueOf(realPath) + "/templates");
            }
        } else {
            cssPath = new File(servletContext.getRealPath(theme.getCssPath()));
            imagesPath = new File(servletContext.getRealPath(theme.getImagesPath()));
            javaScriptPath = new File(servletContext.getRealPath(theme.getJavaScriptPath()));
            templatesPath = new File(servletContext.getRealPath(theme.getTemplatesPath()));
        }
        this.exportThemeFiles("css", cssPath, themeZipWriter);
        this.exportThemeFiles("images", imagesPath, themeZipWriter);
        this.exportThemeFiles("javascript", javaScriptPath, themeZipWriter);
        this.exportThemeFiles("templates", templatesPath, themeZipWriter);
    }

    protected void exportThemeFiles(String path, File dir, ZipWriter zipWriter) throws Exception {
        File[] files;
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.exportThemeFiles(String.valueOf(path) + "/" + file.getName(), file, zipWriter);
            } else {
                zipWriter.addEntry(String.valueOf(path) + "/" + file.getName(), FileUtil.getBytes((File)file));
            }
            ++n2;
        }
    }

    protected void fixTypeSettings(Layout layout) throws Exception {
        String groupFriendlyURL;
        if (!layout.isTypeURL()) {
            return;
        }
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = GetterUtil.getString((String)typeSettings.getProperty("url"));
        String friendlyURLPrivateGroupPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        String friendlyURLPrivateUserPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        String friendlyURLPublicPath = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        if (!(url.startsWith(friendlyURLPrivateGroupPath) || url.startsWith(friendlyURLPrivateUserPath) || url.startsWith(friendlyURLPublicPath))) {
            return;
        }
        int x = url.indexOf(47, 1);
        if (x == -1) {
            return;
        }
        int y = url.indexOf(47, x + 1);
        if (y == -1) {
            return;
        }
        String friendlyURL = url.substring(x, y);
        if (!friendlyURL.equals(groupFriendlyURL = layout.getGroup().getFriendlyURL())) {
            return;
        }
        typeSettings.setProperty("url", String.valueOf(url.substring(0, x)) + SAME_GROUP_FRIENDLY_URL + url.substring(y));
    }

    protected boolean[] getExportPortletControls(long companyId, String portletId, PortletDataContext context, Map<String, String[]> parameterMap) throws Exception {
        boolean exportPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean exportPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        boolean exportPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export portlet data " + exportPortletData));
            _log.debug((Object)("Export all portlet data " + exportPortletDataAll));
            _log.debug((Object)("Export portlet setup " + exportPortletSetup));
        }
        boolean exportCurPortletData = exportPortletData;
        boolean exportCurPortletSetup = exportPortletSetup;
        if (exportPortletDataAll) {
            exportCurPortletData = true;
            exportCurPortletSetup = true;
        } else {
            String portletDataHandlerClass;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
            if (portlet != null && (portletDataHandlerClass = portlet.getPortletDataHandlerClass()) != null) {
                String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                exportCurPortletData = exportPortletData && MapUtil.getBoolean(parameterMap, (String)("PORTLET_DATA_" + rootPortletId));
                exportCurPortletSetup = exportPortletData && MapUtil.getBoolean(parameterMap, (String)("PORTLET_SETUP_" + rootPortletId));
            }
        }
        return new boolean[]{exportCurPortletData, exportCurPortletSetup};
    }

    protected String getLayoutIconPath(PortletDataContext context, Layout layout, Image image) {
        StringBundler sb = new StringBundler(5);
        sb.append(context.getLayoutPath(layout.getLayoutId()));
        sb.append("/icons/");
        sb.append(image.getImageId());
        sb.append(".");
        sb.append(image.getType());
        return sb.toString();
    }
}

