/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Map;

public class ShutdownHook
implements Runnable {
    public void run() {
        if (GetterUtil.getBoolean((String)System.getProperty("shutdown.hook.print.full.thread.dump"))) {
            this.printFullThreadDump();
        }
    }

    protected void printFullThreadDump() {
        StringBundler sb = new StringBundler();
        sb.append("Full thread dump ");
        sb.append(System.getProperty("java.vm.name"));
        sb.append(" ");
        sb.append(System.getProperty("java.vm.version"));
        sb.append("\n\n");
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] elements = entry.getValue();
            sb.append("\"");
            sb.append(thread.getName());
            sb.append("\"");
            if (thread.getThreadGroup() != null) {
                sb.append(" (");
                sb.append(thread.getThreadGroup().getName());
                sb.append(")");
            }
            sb.append(", priority=");
            sb.append(thread.getPriority());
            sb.append(", id=");
            sb.append(thread.getId());
            sb.append(", state=");
            sb.append((Object)thread.getState());
            sb.append("\n");
            int i = 0;
            while (i < elements.length) {
                sb.append("\t");
                sb.append((Object)elements[i]);
                sb.append("\n");
                ++i;
            }
            sb.append("\n");
        }
        System.out.println(sb);
    }
}

