/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.jpa;

import com.liferay.portal.dao.orm.jpa.ExceptionTranslator;
import com.liferay.portal.dao.orm.jpa.QueryImpl;
import com.liferay.portal.dao.orm.jpa.SessionImpl;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnmodifiableList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLQueryImpl
extends QueryImpl
implements SQLQuery {
    private static Map<Class<?>, String[]> _entityColumns = new ConcurrentHashMap();
    private List<Integer> _scalars = new ArrayList<Integer>();
    private List<Type> _scalarTypes = new ArrayList<Type>();

    public SQLQueryImpl(SessionImpl sessionImpl, String queryString) {
        super(sessionImpl, queryString);
        this.sqlQuery = true;
    }

    public SQLQuery addEntity(String alias, Class<?> entityClass) {
        String columnAliases = null;
        try {
            String[] columnNames = this._getColumns(entityClass);
            if (columnNames.length == 0) {
                columnAliases = "";
            } else {
                StringBundler sb = new StringBundler(columnNames.length * 4 - 1);
                int i = 0;
                String[] stringArray = columnNames;
                int n = columnNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String column = stringArray[n2];
                    sb.append(alias);
                    sb.append(".");
                    sb.append(column);
                    if (i + 1 < columnNames.length) {
                        sb.append(", ");
                    }
                    ++i;
                    ++n2;
                }
                columnAliases = sb.toString();
            }
        }
        catch (Exception e) {
            throw new ORMException(e.getMessage());
        }
        String escapedAlias = Pattern.quote("{" + alias + ".*}");
        this.queryString = this.queryString.replaceAll(escapedAlias, columnAliases);
        this.entityClass = entityClass;
        return this;
    }

    public SQLQuery addScalar(String columnAlias, Type type) {
        columnAlias = columnAlias.toLowerCase();
        String q = this.queryString.toLowerCase();
        int fromIndex = q.indexOf("from");
        if (fromIndex == -1) {
            return this;
        }
        String selectExpression = q.substring(0, fromIndex);
        String[] selectTokens = selectExpression.split(",");
        int pos = 0;
        while (pos < selectTokens.length) {
            String s = selectTokens[pos];
            if (s.indexOf(columnAlias) != -1) {
                this._scalars.add(pos);
                this._scalarTypes.add(type);
            }
            ++pos;
        }
        return this;
    }

    @Override
    public List<?> list(boolean unmodifiable) throws ORMException {
        try {
            List<?> list = this.sessionImpl.list(this.queryString, this.parameterMap, this.firstResult, this.maxResults, this.flushModeType, this.sqlQuery, this.entityClass);
            if (this.entityClass == null && !list.isEmpty()) {
                list = this._transformList(list);
            }
            if (unmodifiable) {
                return new UnmodifiableList(list);
            }
            return ListUtil.copy(list);
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    @Override
    public Object uniqueResult() throws ORMException {
        try {
            Collection collection;
            Object object = this.sessionImpl.uniqueResult(this.queryString, this.parameterMap, this.firstResult, this.maxResults, this.flushModeType, this.sqlQuery, this.entityClass);
            if (object instanceof Collection && (collection = (Collection)object).size() == 1) {
                object = collection.iterator().next();
            }
            if (this._scalars.size() == 1) {
                object = this._transformType(object, this._scalarTypes.get(0));
            }
            return object;
        }
        catch (Exception e) {
            throw ExceptionTranslator.translate(e);
        }
    }

    private String[] _getColumns(Class<?> entityClass) throws Exception {
        String[] columns = _entityColumns.get(entityClass);
        if (columns != null) {
            return columns;
        }
        Field field = entityClass.getField("TABLE_COLUMNS");
        Object[][] tableColumns = (Object[][])field.get(null);
        columns = new String[tableColumns.length];
        int i = 0;
        Object[][] objectArray = tableColumns;
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] row = objectArray[n2];
            String name = (String)row[0];
            columns[i++] = name.toUpperCase();
            ++n2;
        }
        _entityColumns.put(entityClass, columns);
        return columns;
    }

    private List<?> _transformList(List<?> list) throws Exception {
        if (!this._scalars.isEmpty()) {
            Collections.sort(this._scalars);
            if (list.get(0) instanceof Collection) {
                ArrayList newList = new ArrayList();
                for (Collection collection : list) {
                    Object[] array = collection.toArray();
                    if (this._scalars.size() > 1) {
                        Object[] values = new Object[this._scalars.size()];
                        int i = 0;
                        while (i < this._scalars.size()) {
                            values[i] = array[this._scalars.get(i)];
                            ++i;
                        }
                        newList.add(values);
                        continue;
                    }
                    newList.add(array[this._scalars.get(0)]);
                }
                list = newList;
            } else if (list.get(0) instanceof Object[]) {
                ArrayList newList = new ArrayList();
                for (Object[] array : list) {
                    if (this._scalars.size() > 1) {
                        Object[] values = new Object[this._scalars.size()];
                        int i = 0;
                        while (i < this._scalars.size()) {
                            values[i] = array[this._scalars.get(i)];
                            ++i;
                        }
                        newList.add(values);
                        continue;
                    }
                    newList.add(array[this._scalars.get(0)]);
                }
                list = newList;
            } else if (this._scalars.size() == 1) {
                ArrayList newList = new ArrayList();
                for (Object value : list) {
                    value = this._transformType(value, this._scalarTypes.get(0));
                    newList.add(value);
                }
                list = newList;
            }
        } else if (list.get(0) instanceof Collection) {
            ArrayList newList = new ArrayList();
            for (Collection collection : list) {
                if (collection.size() == 1) {
                    newList.add(collection.iterator().next());
                    continue;
                }
                newList.add(collection.toArray());
            }
            list = newList;
        }
        return list;
    }

    private Object _transformType(Object object, Type type) {
        Object result = object;
        if (type.equals((Object)Type.LONG)) {
            if (object instanceof Integer) {
                result = new Long(((Integer)object).longValue());
            }
        } else if (type.equals((Object)Type.STRING)) {
            result = object.toString();
        } else {
            throw new UnsupportedOperationException("Type conversion from " + object.getClass().getName() + " to " + type + " is not supported");
        }
        return result;
    }
}

