/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheWrapper
implements Cache,
CacheRegistryItem {
    private static Log _log = LogFactoryUtil.getLog(CacheWrapper.class);
    private Cache _cache;
    private String _registryName;

    public CacheWrapper(Cache cache) {
        this._cache = cache;
        this._registryName = cache.getRegionName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Creating cache for " + this._registryName));
        }
        CacheRegistryUtil.register((CacheRegistryItem)this);
    }

    public void clear() throws CacheException {
        this._cache.clear();
    }

    public void destroy() throws CacheException {
        this._cache.destroy();
    }

    public Object get(Object key) throws CacheException {
        return this._cache.get(key);
    }

    public long getElementCountInMemory() {
        return this._cache.getElementCountInMemory();
    }

    public long getElementCountOnDisk() {
        return this._cache.getElementCountOnDisk();
    }

    public String getRegionName() {
        return this._cache.getRegionName();
    }

    public String getRegistryName() {
        return this._registryName;
    }

    public long getSizeInMemory() {
        return this._cache.getSizeInMemory();
    }

    public int getTimeout() {
        return this._cache.getTimeout();
    }

    public void lock(Object key) throws CacheException {
        this._cache.lock(key);
    }

    public long nextTimestamp() {
        return this._cache.nextTimestamp();
    }

    public void put(Object key, Object value) throws CacheException {
        if (CacheRegistryUtil.isActive()) {
            this._cache.put(key, value);
        }
    }

    public Object read(Object key) throws CacheException {
        return this._cache.read(key);
    }

    public void remove(Object key) throws CacheException {
        this._cache.remove(key);
    }

    public Map<?, ?> toMap() {
        return this._cache.toMap();
    }

    public void unlock(Object key) throws CacheException {
        this._cache.unlock(key);
    }

    public void update(Object key, Object value) throws CacheException {
        if (CacheRegistryUtil.isActive()) {
            this._cache.update(key, value);
        }
    }

    public void invalidate() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invalidating cache for " + this._registryName));
        }
        this._cache.clear();
    }
}

