/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateClassLoader
extends ClassLoader {
    private static Log _log = LogFactoryUtil.getLog(AggregateClassLoader.class);
    private List<ClassLoaderWrapper> _classLoaders = new ArrayList<ClassLoaderWrapper>();

    public static ClassLoader getAggregateClassLoader(ClassLoader parentClassLoader, ClassLoader[] classLoaders) {
        if (classLoaders == null || classLoaders.length == 0) {
            return null;
        }
        if (classLoaders.length == 1) {
            return classLoaders[0];
        }
        AggregateClassLoader aggregateClassLoader = new AggregateClassLoader(parentClassLoader);
        ClassLoader[] classLoaderArray = classLoaders;
        int n = classLoaders.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classLoader = classLoaderArray[n2];
            aggregateClassLoader.addClassLoader(classLoader);
            ++n2;
        }
        return aggregateClassLoader;
    }

    public static ClassLoader getAggregateClassLoader(ClassLoader[] classLoaders) {
        if (classLoaders == null || classLoaders.length == 0) {
            return null;
        }
        return AggregateClassLoader.getAggregateClassLoader(classLoaders[0], classLoaders);
    }

    public AggregateClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (this._classLoaders.contains(classLoader)) {
            return;
        }
        if (classLoader instanceof AggregateClassLoader && classLoader.getParent().equals(this.getParent())) {
            AggregateClassLoader aggregateClassLoader = (AggregateClassLoader)classLoader;
            for (ClassLoader classLoader2 : aggregateClassLoader.getClassLoaders()) {
                this.addClassLoader(classLoader2);
            }
        } else if (classLoader instanceof ClassLoaderWrapper) {
            this._classLoaders.add((ClassLoaderWrapper)classLoader);
        } else {
            this._classLoaders.add(new ClassLoaderWrapper(classLoader));
        }
    }

    public void addClassLoader(ClassLoader ... classLoaders) {
        ClassLoader[] classLoaderArray = classLoaders;
        int n = classLoaders.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classLoader = classLoaderArray[n2];
            this.addClassLoader(classLoader);
            ++n2;
        }
    }

    public void addClassLoader(Collection<ClassLoader> classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            this.addClassLoader(classLoader);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AggregateClassLoader)) {
            return false;
        }
        AggregateClassLoader aggregateClassLoader = (AggregateClassLoader)obj;
        return this._classLoaders.equals(aggregateClassLoader._classLoaders) && (this.getParent() == null && aggregateClassLoader.getParent() == null || this.getParent() != null && this.getParent().equals(aggregateClassLoader.getParent()));
    }

    public List<ClassLoaderWrapper> getClassLoaders() {
        return this._classLoaders;
    }

    public int hashCode() {
        if (this._classLoaders != null) {
            return this._classLoaders.hashCode();
        }
        return 0;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoaderWrapper classLoader : this._classLoaders) {
            try {
                return classLoader.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException("Unable to find class " + name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = null;
        for (ClassLoaderWrapper classLoader : this._classLoaders) {
            try {
                loadedClass = classLoader.loadClass(name, resolve);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (loadedClass == null) {
            loadedClass = super.loadClass(name, resolve);
        } else if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassLoaderWrapper
    extends ClassLoader {
        private static Method _findClassMethod;

        static {
            block2: {
                try {
                    _findClassMethod = ClassLoader.class.getDeclaredMethod("findClass", String.class);
                    _findClassMethod.setAccessible(true);
                }
                catch (NoSuchMethodException nsme) {
                    if (!_log.isErrorEnabled()) break block2;
                    _log.error("Unable to locate findClass method", nsme);
                }
            }
        }

        public ClassLoaderWrapper(ClassLoader classLoader) {
            super(classLoader);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassLoader)) {
                return false;
            }
            return this.getParent().equals(obj);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return (Class)_findClassMethod.invoke((Object)this.getParent(), name);
            }
            catch (InvocationTargetException ite) {
                throw new ClassNotFoundException("Unable to find class " + name, ite.getTargetException());
            }
            catch (Exception e) {
                throw new ClassNotFoundException("Unable to find class " + name, e);
            }
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }
}

