/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterLinkUtil {
    private static final String _ADDRESS = "CLUSTER_ADDRESS";
    private static final String _CLUSTER_FORWARD_MESSAGE = "CLUSTER_FORWARD_MESSAGE";
    private static Log _log = LogFactoryUtil.getLog(ClusterLinkUtil.class);
    private static ClusterLink _clusterLink;

    public static Address getAddress(Message message) {
        return (Address)message.get(_ADDRESS);
    }

    public static ClusterLink getClusterLink() {
        if (_clusterLink == null || !_clusterLink.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterLinkUtil has not been initialized");
            }
            return null;
        }
        return _clusterLink;
    }

    public static List<Address> getLocalTransportAddresses() {
        if (_clusterLink == null || !_clusterLink.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterLinkUtil has not been initialized");
            }
            return Collections.EMPTY_LIST;
        }
        return _clusterLink.getLocalTransportAddresses();
    }

    public static List<Address> getTransportAddresses(Priority priority) {
        if (_clusterLink == null || !_clusterLink.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterLinkUtil has not been initialized");
            }
            return Collections.EMPTY_LIST;
        }
        return _clusterLink.getTransportAddresses(priority);
    }

    public static boolean isForwardMessage(Message message) {
        return message.getBoolean(_CLUSTER_FORWARD_MESSAGE);
    }

    public static void sendMulticastMessage(Message message, Priority priority) {
        if (_clusterLink == null || !_clusterLink.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterLinkUtil has not been initialized");
            }
            return;
        }
        _clusterLink.sendMulticastMessage(message, priority);
    }

    public static void sendMulticastMessage(Object payload, Priority priority) {
        Message message = new Message();
        message.setPayload(payload);
        ClusterLinkUtil.sendMulticastMessage(message, priority);
    }

    public static void sendUnicastMessage(Address address, Message message, Priority priority) {
        if (_clusterLink == null || !_clusterLink.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterLinkUtil has not been initialized");
            }
            return;
        }
        _clusterLink.sendUnicastMessage(address, message, priority);
    }

    public static Message setAddress(Message message, Address address) {
        message.put(_ADDRESS, address);
        return message;
    }

    public static void setForwardMessage(Message message) {
        message.put(_CLUSTER_FORWARD_MESSAGE, true);
    }

    public void setClusterLink(ClusterLink clusterLink) {
        _clusterLink = clusterLink;
    }
}

