/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.DeprecationException;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class GroovyClassLoader
extends URLClassLoader {
    protected final Map classCache = new HashMap();
    protected final Map sourceCache = new HashMap();
    private final CompilerConfiguration config;
    private Boolean recompile;
    private static int scriptNameCounter = 1000000;
    private GroovyResourceLoader resourceLoader = new GroovyResourceLoader(){

        public URL loadGroovySource(final String filename) throws MalformedURLException {
            URL file = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return GroovyClassLoader.this.getSourceFile(filename);
                }
            });
            return file;
        }
    };

    public GroovyClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public GroovyClassLoader(ClassLoader loader) {
        this(loader, null);
    }

    public GroovyClassLoader(GroovyClassLoader parent) {
        this(parent, parent.config, false);
    }

    public GroovyClassLoader(ClassLoader parent, CompilerConfiguration config, boolean useConfigurationClasspath) {
        super(new URL[0], parent);
        if (config == null) {
            config = CompilerConfiguration.DEFAULT;
        }
        this.config = config;
        if (useConfigurationClasspath) {
            for (String path : config.getClasspath()) {
                this.addClasspath(path);
            }
        }
    }

    public GroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
        this(loader, config, true);
    }

    public void setResourceLoader(GroovyResourceLoader resourceLoader) {
        if (resourceLoader == null) {
            throw new IllegalArgumentException("Resource loader must not be null!");
        }
        this.resourceLoader = resourceLoader;
    }

    public GroovyResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Class defineClass(ClassNode classNode, String file) {
        throw new DeprecationException("the method GroovyClassLoader#defineClass(ClassNode, String) is no longer used and removed");
    }

    public Class defineClass(ClassNode classNode, String file, String newCodeBase) {
        CodeSource codeSource = null;
        try {
            codeSource = new CodeSource(new URL("file", "", newCodeBase), (Certificate[])null);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        CompilationUnit unit = this.createCompilationUnit(this.config, codeSource);
        ClassCollector collector = this.createCollector(unit, classNode.getModule().getContext());
        try {
            unit.addClassNode(classNode);
            unit.setClassgenCallback(collector);
            unit.compile(7);
            this.definePackage(collector.generatedClass.getName());
            return collector.generatedClass;
        }
        catch (CompilationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public Class parseClass(File file) throws CompilationFailedException, IOException {
        return this.parseClass(new GroovyCodeSource(file, this.config.getSourceEncoding()));
    }

    public Class parseClass(final String text, final String fileName) throws CompilationFailedException {
        GroovyCodeSource gcs = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyCodeSource(text, fileName, "/groovy/script");
            }
        });
        return this.parseClass(gcs);
    }

    public Class parseClass(String text) throws CompilationFailedException {
        return this.parseClass(text, "script" + System.currentTimeMillis() + Math.abs(text.hashCode()) + ".groovy");
    }

    public Class parseClass(InputStream in) throws CompilationFailedException {
        return this.parseClass(in, this.generateScriptName());
    }

    public synchronized String generateScriptName() {
        return "script" + ++scriptNameCounter + ".groovy";
    }

    public Class parseClass(final InputStream in, final String fileName) throws CompilationFailedException {
        GroovyCodeSource gcs = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    String scriptText = GroovyClassLoader.this.config.getSourceEncoding() != null ? DefaultGroovyMethods.getText(in, GroovyClassLoader.this.config.getSourceEncoding()) : DefaultGroovyMethods.getText(in);
                    return new GroovyCodeSource(scriptText, fileName, "/groovy/script");
                }
                catch (IOException e) {
                    throw new RuntimeException("Impossible to read the content of the input stream for file named: " + fileName, e);
                }
            }
        });
        return this.parseClass(gcs);
    }

    public Class parseClass(GroovyCodeSource codeSource) throws CompilationFailedException {
        return this.parseClass(codeSource, codeSource.isCachable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class parseClass(GroovyCodeSource codeSource, boolean shouldCacheSource) throws CompilationFailedException {
        Map map = this.sourceCache;
        synchronized (map) {
            Class answer = (Class)this.sourceCache.get(codeSource.getName());
            if (answer != null) {
                return answer;
            }
            CompilationUnit unit = this.createCompilationUnit(this.config, codeSource.getCodeSource());
            SourceUnit su = null;
            su = codeSource.getFile() == null ? unit.addSource(codeSource.getName(), codeSource.getScriptText()) : unit.addSource(codeSource.getFile());
            ClassCollector collector = this.createCollector(unit, su);
            unit.setClassgenCallback(collector);
            int goalPhase = 7;
            if (this.config != null && this.config.getTargetDirectory() != null) {
                goalPhase = 8;
            }
            unit.compile(goalPhase);
            answer = collector.generatedClass;
            for (Class clazz : collector.getLoadedClasses()) {
                this.definePackage(clazz.getName());
                this.setClassCacheEntry(clazz);
            }
            if (shouldCacheSource) {
                this.sourceCache.put(codeSource.getName(), answer);
            }
            return answer;
        }
    }

    private void definePackage(String className) {
        String pkgName;
        Package pkg;
        int i = className.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgName = className.substring(0, i))) == null) {
            this.definePackage(pkgName, null, null, null, null, null, null, null);
        }
    }

    protected String[] getClassPath() {
        URL[] urls = this.getURLs();
        String[] ret = new String[urls.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = urls[i].getFile();
        }
        return ret;
    }

    protected void expandClassPath(List pathList, String base, String classpath, boolean isManifestClasspath) {
        throw new DeprecationException("the method groovy.lang.GroovyClassLoader#expandClassPath(List,String,String,boolean) is no longer used internally and removed");
    }

    protected Class defineClass(String name, byte[] bytecode, ProtectionDomain domain) {
        throw new DeprecationException("the method groovy.lang.GroovyClassLoader#defineClass(String,byte[],ProtectionDomain) is no longer used internally and removed");
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection perms;
        try {
            perms = super.getPermissions(codeSource);
        }
        catch (SecurityException e) {
            perms = new Permissions();
        }
        ProtectionDomain myDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return this.getClass().getProtectionDomain();
            }
        });
        PermissionCollection myPerms = myDomain.getPermissions();
        if (myPerms != null) {
            Enumeration<Permission> elements = myPerms.elements();
            while (elements.hasMoreElements()) {
                perms.add(elements.nextElement());
            }
        }
        perms.setReadOnly();
        return perms;
    }

    protected CompilationUnit createCompilationUnit(CompilerConfiguration config, CodeSource source) {
        return new CompilationUnit(config, source, this);
    }

    protected ClassCollector createCollector(CompilationUnit unit, SourceUnit su) {
        InnerLoader loader = (InnerLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new InnerLoader(GroovyClassLoader.this);
            }
        });
        return new ClassCollector(loader, unit, su);
    }

    public Class defineClass(String name, byte[] b) {
        return super.defineClass(name, b, 0, b.length);
    }

    public Class loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript) throws ClassNotFoundException, CompilationFailedException {
        return this.loadClass(name, lookupScriptFiles, preferClassOverScript, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getClassCacheEntry(String name) {
        if (name == null) {
            return null;
        }
        Map map = this.classCache;
        synchronized (map) {
            return (Class)this.classCache.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClassCacheEntry(Class cls) {
        Map map = this.classCache;
        synchronized (map) {
            this.classCache.put(cls.getName(), cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClassCacheEntry(String name) {
        Map map = this.classCache;
        synchronized (map) {
            this.classCache.remove(name);
        }
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    protected boolean isRecompilable(Class cls) {
        if (cls == null) {
            return true;
        }
        if (cls.getClassLoader() == this) {
            return false;
        }
        if (this.recompile == null && !this.config.getRecompileGroovySource()) {
            return false;
        }
        if (this.recompile != null && !this.recompile.booleanValue()) {
            return false;
        }
        if (!GroovyObject.class.isAssignableFrom(cls)) {
            return false;
        }
        long timestamp = this.getTimeStamp(cls);
        return timestamp != Long.MAX_VALUE;
    }

    public void setShouldRecompile(Boolean mode) {
        this.recompile = mode;
    }

    public Boolean isShouldRecompile() {
        return this.recompile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript, boolean resolve) throws ClassNotFoundException, CompilationFailedException {
        String className;
        int i;
        Class cls = this.getClassCacheEntry(name);
        boolean recompile = this.isRecompilable(cls);
        if (!recompile) {
            return cls;
        }
        ClassNotFoundException last = null;
        try {
            Class<?> parentClassLoaderClass = super.loadClass(name, resolve);
            if (cls != parentClassLoaderClass) {
                return parentClassLoaderClass;
            }
        }
        catch (ClassNotFoundException cnfe) {
            last = cnfe;
        }
        catch (NoClassDefFoundError ncdfe) {
            if (ncdfe.getMessage().indexOf("wrong name") <= 0) {
                throw ncdfe;
            }
            last = new ClassNotFoundException(name);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (i = (className = name.replace('/', '.')).lastIndexOf(46)) != -1 && !className.startsWith("sun.reflect.")) {
            sm.checkPackageAccess(className.substring(0, i));
        }
        if (cls != null && preferClassOverScript) {
            return cls;
        }
        if (lookupScriptFiles) {
            Map map = this.sourceCache;
            synchronized (map) {
                try {
                    Class classCacheEntry = this.getClassCacheEntry(name);
                    if (classCacheEntry != cls) {
                        Class clazz = classCacheEntry;
                        return clazz;
                    }
                    URL source = this.resourceLoader.loadGroovySource(name);
                    Class oldClass = cls;
                    cls = null;
                    cls = this.recompile(source, name, oldClass);
                }
                catch (IOException ioe) {
                    last = new ClassNotFoundException("IOException while opening groovy source: " + name, ioe);
                }
                finally {
                    if (cls == null) {
                        this.removeClassCacheEntry(name);
                    } else {
                        this.setClassCacheEntry(cls);
                    }
                }
            }
        }
        if (cls != null) {
            return cls;
        }
        if (last == null) {
            throw new AssertionError(true);
        }
        throw last;
    }

    protected Class recompile(URL source, String className, Class oldClass) throws CompilationFailedException, IOException {
        if (source != null && (oldClass != null && this.isSourceNewer(source, oldClass) || oldClass == null)) {
            this.sourceCache.remove(className);
            return this.parseClass(source.openStream(), className);
        }
        return oldClass;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, true, true, resolve);
    }

    protected long getTimeStamp(Class cls) {
        return Verifier.getTimestamp(cls);
    }

    private String decodeFileName(String fileName) {
        String decodedFile = fileName;
        try {
            decodedFile = URLDecoder.decode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Encounted an invalid encoding scheme when trying to use URLDecoder.decode() inside of the GroovyClassLoader.decodeFileName() method.  Returning the unencoded URL.");
            System.err.println("Please note that if you encounter this error and you have spaces in your directory you will run into issues.  Refer to GROOVY-1787 for description of this bug.");
        }
        return decodedFile;
    }

    private boolean isFile(URL ret) {
        return ret != null && ret.getProtocol().equals("file");
    }

    private File getFileForUrl(URL ret, String filename) {
        File file;
        File path;
        String fileWithoutPackage = filename;
        if (fileWithoutPackage.indexOf(47) != -1) {
            int index = fileWithoutPackage.lastIndexOf(47);
            fileWithoutPackage = fileWithoutPackage.substring(index + 1);
        }
        if ((path = new File(this.decodeFileName(ret.getFile())).getParentFile()).exists() && path.isDirectory() && (file = new File(path, fileWithoutPackage)).exists()) {
            File parent = file.getParentFile();
            String[] files = parent.list();
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].equals(fileWithoutPackage)) continue;
                return file;
            }
        }
        return null;
    }

    private URL getSourceFile(String name) {
        String filename = name.replace('.', '/') + this.config.getDefaultScriptExtension();
        URL ret = this.getResource(filename);
        if (this.isFile(ret) && this.getFileForUrl(ret, filename) == null) {
            return null;
        }
        return ret;
    }

    protected boolean isSourceNewer(URL source, Class cls) throws IOException {
        long lastMod;
        if (this.isFile(source)) {
            String path = source.getPath().replace('/', File.separatorChar).replace('|', ':');
            File file = new File(path);
            lastMod = file.lastModified();
        } else {
            URLConnection conn = source.openConnection();
            lastMod = conn.getLastModified();
            conn.getInputStream().close();
        }
        long classTime = this.getTimeStamp(cls);
        return classTime + (long)this.config.getMinimumRecompilationInterval() < lastMod;
    }

    public void addClasspath(final String path) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    File f = new File(path);
                    URL newURL = f.toURI().toURL();
                    URL[] urls = GroovyClassLoader.this.getURLs();
                    for (int i = 0; i < urls.length; ++i) {
                        if (!urls[i].equals(newURL)) continue;
                        return null;
                    }
                    GroovyClassLoader.this.addURL(newURL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getLoadedClasses() {
        Map map = this.classCache;
        synchronized (map) {
            Collection values = this.classCache.values();
            return values.toArray(new Class[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map map = this.classCache;
        synchronized (map) {
            this.classCache.clear();
        }
        map = this.sourceCache;
        synchronized (map) {
            this.sourceCache.clear();
        }
    }

    public static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        private Class generatedClass;
        private final GroovyClassLoader cl;
        private final SourceUnit su;
        private final CompilationUnit unit;
        private final Collection loadedClasses;

        protected ClassCollector(InnerLoader cl, CompilationUnit unit, SourceUnit su) {
            this.cl = cl;
            this.unit = unit;
            this.loadedClasses = new ArrayList();
            this.su = su;
        }

        protected GroovyClassLoader getDefiningClassLoader() {
            return this.cl;
        }

        protected Class createClass(byte[] code, ClassNode classNode) {
            GroovyClassLoader cl = this.getDefiningClassLoader();
            Class theClass = cl.defineClass(classNode.getName(), code, 0, code.length, this.unit.getAST().getCodeSource());
            this.loadedClasses.add(theClass);
            if (this.generatedClass == null) {
                ModuleNode mn = classNode.getModule();
                SourceUnit msu = null;
                if (mn != null) {
                    msu = mn.getContext();
                }
                ClassNode main = null;
                if (mn != null) {
                    main = mn.getClasses().get(0);
                }
                if (msu == this.su && main == classNode) {
                    this.generatedClass = theClass;
                }
            }
            return theClass;
        }

        protected Class onClassNode(ClassWriter classWriter, ClassNode classNode) {
            byte[] code = classWriter.toByteArray();
            return this.createClass(code, classNode);
        }

        public void call(ClassVisitor classWriter, ClassNode classNode) {
            this.onClassNode((ClassWriter)classWriter, classNode);
        }

        public Collection getLoadedClasses() {
            return this.loadedClasses;
        }
    }

    public static class InnerLoader
    extends GroovyClassLoader {
        private final GroovyClassLoader delegate;
        private final long timeStamp;

        public InnerLoader(GroovyClassLoader delegate) {
            super(delegate);
            this.delegate = delegate;
            this.timeStamp = System.currentTimeMillis();
        }

        public void addClasspath(String path) {
            this.delegate.addClasspath(path);
        }

        public void clearCache() {
            this.delegate.clearCache();
        }

        public URL findResource(String name) {
            return this.delegate.findResource(name);
        }

        public Enumeration findResources(String name) throws IOException {
            return this.delegate.findResources(name);
        }

        public Class[] getLoadedClasses() {
            return this.delegate.getLoadedClasses();
        }

        public URL getResource(String name) {
            return this.delegate.getResource(name);
        }

        public InputStream getResourceAsStream(String name) {
            return this.delegate.getResourceAsStream(name);
        }

        public GroovyResourceLoader getResourceLoader() {
            return this.delegate.getResourceLoader();
        }

        public URL[] getURLs() {
            return this.delegate.getURLs();
        }

        public Class loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript, boolean resolve) throws ClassNotFoundException, CompilationFailedException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            return this.delegate.loadClass(name, lookupScriptFiles, preferClassOverScript, resolve);
        }

        public Class parseClass(GroovyCodeSource codeSource, boolean shouldCache) throws CompilationFailedException {
            return this.delegate.parseClass(codeSource, shouldCache);
        }

        public void setResourceLoader(GroovyResourceLoader resourceLoader) {
            this.delegate.setResourceLoader(resourceLoader);
        }

        public void addURL(URL url) {
            this.delegate.addURL(url);
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }
    }
}

