/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.abdera.protocol.Request;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.impl.SimpleTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexTargetResolver
implements Resolver<Target> {
    protected final Map<Pattern, TargetType> patterns = new HashMap<Pattern, TargetType>();
    protected final Map<Pattern, String[]> fields = new HashMap<Pattern, String[]>();

    public RegexTargetResolver() {
    }

    public RegexTargetResolver(Map<String, TargetType> patterns) {
        for (String p : patterns.keySet()) {
            TargetType type = patterns.get(p);
            this.setPattern(p, type);
        }
    }

    public RegexTargetResolver setPattern(String pattern, TargetType type) {
        return this.setPattern(pattern, type, new String[0]);
    }

    public RegexTargetResolver setPattern(String pattern, TargetType type, String ... fields) {
        Pattern p = Pattern.compile(pattern);
        this.patterns.put(p, type);
        this.fields.put(p, fields);
        return this;
    }

    @Override
    public Target resolve(Request request) {
        RequestContext context = (RequestContext)request;
        String uri = context.getTargetPath();
        for (Pattern pattern : this.patterns.keySet()) {
            Matcher matcher = pattern.matcher(uri);
            if (!matcher.matches()) continue;
            TargetType type = this.patterns.get(pattern);
            String[] fields = this.fields.get(pattern);
            return this.getTarget(type, context, matcher, fields);
        }
        return null;
    }

    protected Target getTarget(TargetType type, RequestContext request, Matcher matcher, String[] fields) {
        return new RegexTarget(type, request, matcher, fields);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Regex Target Resolver:\n");
        for (Pattern pattern : this.patterns.keySet()) {
            TargetType type = this.patterns.get(pattern);
            Object[] fields = this.fields.get(pattern);
            buf.append(pattern.toString() + ", Type: " + type + ", Fields: " + Arrays.toString(fields));
        }
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fields == null ? 0 : ((Object)this.fields).hashCode());
        result = 31 * result + (this.patterns == null ? 0 : ((Object)this.patterns).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegexTargetResolver other = (RegexTargetResolver)obj;
        if (this.fields == null ? other.fields != null : !((Object)this.fields).equals(other.fields)) {
            return false;
        }
        return !(this.patterns == null ? other.patterns != null : !((Object)this.patterns).equals(other.patterns));
    }

    public static class RegexTarget
    extends SimpleTarget
    implements Target {
        private static final long serialVersionUID = 165211244926064449L;
        protected Matcher matcher;
        protected String[] fields;

        public RegexTarget(TargetType type, RequestContext context, Matcher matcher, String[] fields) {
            super(type, context);
            this.matcher = matcher;
            this.fields = fields;
        }

        public String getParameter(String name) {
            if (this.fields == null) {
                return super.getParameter(name);
            }
            int idx = 0;
            for (int n = 0; n < this.fields.length; ++n) {
                if (!this.fields[n].equalsIgnoreCase(name)) continue;
                idx = n + 1;
            }
            return idx > 0 && idx <= this.matcher.groupCount() ? this.matcher.group(idx) : super.getParameter(name);
        }

        public String[] getParameterNames() {
            String[] names = super.getParameterNames();
            ArrayList<String> list = new ArrayList<String>();
            if (names != null) {
                list.addAll(Arrays.asList(names));
            }
            if (this.fields != null) {
                list.addAll(Arrays.asList(this.fields));
            }
            return list.toArray(new String[list.size()]);
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            String m = this.matcher.group(0);
            String p = this.matcher.pattern().pattern();
            result = 31 * result + super.hashCode();
            result = 31 * result + (m == null ? 0 : m.hashCode());
            result = 31 * result + (p == null ? 0 : p.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RegexTarget other = (RegexTarget)obj;
            String m = this.matcher.group(0);
            String p = this.matcher.pattern().pattern();
            String m2 = other.matcher.group(0);
            String p2 = other.matcher.pattern().pattern();
            if (!super.equals(obj)) {
                return false;
            }
            if (m == null ? m2 != null : !m.equals(m2)) {
                return false;
            }
            if (p == null ? p2 != null : !p.equals(p2)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            String[] params;
            String m = this.matcher.group(0);
            String p = this.matcher.pattern().pattern();
            StringBuilder buf = new StringBuilder();
            buf.append("RegexTarget[").append(p).append(" ==> ").append(m).append("] = ").append(this.type.toString()).append("\n");
            for (String param : params = this.getParameterNames()) {
                buf.append("    ").append(param).append(" = ").append(this.getParameter(param)).append("\n");
            }
            return buf.toString();
        }

        public String getIdentity() {
            return this.context.getUri().toString();
        }
    }
}

