/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import org.apache.abdera.i18n.text.CharUtils;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.i18n.text.UrlEncoding;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.util.AbstractResponse;
import org.apache.abdera.protocol.util.EncodingUtil;
import org.apache.abdera.util.EntityTag;
import org.apache.abdera.writer.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResponseContext
extends AbstractResponse
implements ResponseContext {
    protected static final String[] EMPTY = new String[0];
    protected int status = 0;
    protected String status_text = null;
    protected Writer writer = null;
    protected Map<String, Object[]> headers = null;

    @Override
    public ResponseContext removeHeader(String name) {
        Map<String, Object[]> headers = this.getHeaders();
        headers.remove(name);
        return this;
    }

    @Override
    public ResponseContext setEncodedHeader(String name, String charset, String value) {
        return this.setHeader(name, (Object)EncodingUtil.encode(value, charset));
    }

    @Override
    public ResponseContext setEncodedHeader(String name, String charset, String ... vals) {
        Object[] evals = new Object[vals.length];
        for (int n = 0; n < vals.length; ++n) {
            evals[n] = EncodingUtil.encode(vals[n], charset);
        }
        return this.setHeader(name, evals);
    }

    @Override
    public ResponseContext setEscapedHeader(String name, CharUtils.Profile profile, String value) {
        return this.setHeader(name, (Object)UrlEncoding.encode((CharSequence)value, profile.filter()));
    }

    @Override
    public ResponseContext setHeader(String name, Object value) {
        return this.setHeader(name, new Object[]{value});
    }

    @Override
    public ResponseContext setHeader(String name, Object ... vals) {
        Map<String, Object[]> headers = this.getHeaders();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object value : vals) {
            values.add(value);
        }
        headers.put(name, values.toArray(new Object[values.size()]));
        return this;
    }

    @Override
    public ResponseContext addEncodedHeader(String name, String charset, String value) {
        return this.addHeader(name, EncodingUtil.encode(value, charset));
    }

    @Override
    public ResponseContext addEncodedHeaders(String name, String charset, String ... vals) {
        for (String value : vals) {
            this.addHeader(name, EncodingUtil.encode(value, charset));
        }
        return this;
    }

    @Override
    public ResponseContext addHeader(String name, Object value) {
        return this.addHeaders(name, value);
    }

    @Override
    public ResponseContext addHeaders(String name, Object ... vals) {
        Map<String, Object[]> headers = this.getHeaders();
        Object[] values = headers.get(name);
        List<Object> l = null;
        l = values == null ? new ArrayList<Object>() : Arrays.asList(values);
        for (Object value : vals) {
            l.add(value);
        }
        headers.put(name, l.toArray(new Object[l.size()]));
        return this;
    }

    public Map<String, Object[]> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object[]>();
        }
        return this.headers;
    }

    @Override
    public Date getDateHeader(String name) {
        Map<String, Object[]> headers = this.getHeaders();
        Object[] values = headers.get(name);
        if (values != null) {
            for (Object value : values) {
                if (!(value instanceof Date)) continue;
                return (Date)value;
            }
        }
        return null;
    }

    @Override
    public String getHeader(String name) {
        Map<String, Object[]> headers = this.getHeaders();
        Object[] values = headers.get(name);
        if (values != null && values.length > 0) {
            return values[0].toString();
        }
        return null;
    }

    @Override
    public Object[] getHeaders(String name) {
        Map<String, Object[]> headers = this.getHeaders();
        return headers.get(name);
    }

    @Override
    public String[] getHeaderNames() {
        Map<String, Object[]> headers = this.getHeaders();
        return headers.keySet().toArray(new String[headers.size()]);
    }

    private void append(StringBuilder buf, String value) {
        if (buf.length() > 0) {
            buf.append(", ");
        }
        buf.append(value);
    }

    @Override
    public String getCacheControl() {
        StringBuilder buf = new StringBuilder();
        if (this.isPublic()) {
            this.append(buf, "public");
        }
        if (this.isPrivate()) {
            this.append(buf, "private");
        }
        if (this.private_headers != null && this.private_headers.length > 0) {
            buf.append("=\"");
            for (String header : this.private_headers) {
                this.append(buf, header);
            }
            buf.append("\"");
        }
        if (this.isNoCache()) {
            this.append(buf, "no-cache");
        }
        if (this.nocache_headers != null && this.nocache_headers.length > 0) {
            buf.append("=\"");
            for (String header : this.nocache_headers) {
                this.append(buf, header);
            }
            buf.append("\"");
        }
        if (this.isNoStore()) {
            this.append(buf, "no-store");
        }
        if (this.isMustRevalidate()) {
            this.append(buf, "must-revalidate");
        }
        if (this.isNoTransform()) {
            this.append(buf, "no-transform");
        }
        if (this.getMaxAge() != -1L) {
            this.append(buf, "max-age=" + this.getMaxAge());
        }
        if (this.getSMaxAge() != -1L) {
            this.append(buf, "smax-age=" + this.getMaxAge());
        }
        return buf.toString();
    }

    @Override
    public ResponseContext setAge(long age) {
        return age == -1L ? this.removeHeader("Age") : this.setHeader("Age", (Object)String.valueOf(age));
    }

    @Override
    public ResponseContext setContentLanguage(String language) {
        return language == null ? this.removeHeader("Content-Language") : this.setHeader("Content-Language", (Object)language);
    }

    @Override
    public ResponseContext setContentLength(long length) {
        return length == -1L ? this.removeHeader("Content-Length") : this.setHeader("Content-Length", (Object)String.valueOf(length));
    }

    @Override
    public ResponseContext setContentLocation(String uri) {
        return uri == null ? this.removeHeader("Content-Location") : this.setHeader("Content-Location", (Object)uri);
    }

    @Override
    public ResponseContext setSlug(String slug) {
        if (slug == null) {
            return this.removeHeader("Slug");
        }
        if (slug.indexOf(10) > -1 || slug.indexOf(13) > -1) {
            throw new IllegalArgumentException(Localizer.get("SLUG.BAD.CHARACTERS"));
        }
        return this.setEscapedHeader("Slug", CharUtils.Profile.ASCIISANSCRLF, slug);
    }

    @Override
    public ResponseContext setContentType(String type) {
        return this.setContentType(type, null);
    }

    @Override
    public ResponseContext setContentType(String type, String charset) {
        if (type == null) {
            return this.removeHeader("Content-Type");
        }
        try {
            MimeType mimeType = new MimeType(type);
            if (charset != null) {
                mimeType.setParameter("charset", charset);
            }
            return this.setHeader("Content-Type", (Object)mimeType.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResponseContext setEntityTag(String etag) {
        return etag != null ? this.setEntityTag(new EntityTag(etag)) : this.removeHeader("ETag");
    }

    @Override
    public ResponseContext setEntityTag(EntityTag etag) {
        return etag == null ? this.removeHeader("ETag") : this.setHeader("ETag", (Object)etag.toString());
    }

    @Override
    public ResponseContext setExpires(Date date) {
        return date == null ? this.removeHeader("Expires") : this.setHeader("Expires", (Object)date);
    }

    @Override
    public ResponseContext setLastModified(Date date) {
        return date == null ? this.removeHeader("Last-Modified") : this.setHeader("Last-Modified", (Object)date);
    }

    @Override
    public ResponseContext setLocation(String uri) {
        return uri == null ? this.removeHeader("Location") : this.setHeader("Location", (Object)uri);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public ResponseContext setStatus(int status) {
        this.status = status;
        return this;
    }

    @Override
    public String getStatusText() {
        return this.status_text;
    }

    @Override
    public ResponseContext setStatusText(String text) {
        this.status_text = text;
        return this;
    }

    @Override
    public ResponseContext setAllow(String method) {
        return this.setHeader("Allow", (Object)method);
    }

    @Override
    public ResponseContext setAllow(String ... methods) {
        StringBuilder buf = new StringBuilder();
        for (String method : methods) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(method);
        }
        return this.setAllow(buf.toString());
    }

    @Override
    public ResponseContext setWriter(Writer writer) {
        this.writer = writer;
        return this;
    }
}

