/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.QueryItem;
import com.ecyrd.jspwiki.SearchMatcher;
import com.ecyrd.jspwiki.SearchResult;
import com.ecyrd.jspwiki.SearchResultComparator;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.WikiPageProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public abstract class AbstractFileProvider
implements WikiPageProvider {
    private static final Logger log = Logger.getLogger(AbstractFileProvider.class);
    private String m_pageDirectory = "/tmp/";
    protected String m_encoding;
    protected WikiEngine m_engine;
    public static final String PROP_PAGEDIR = "jspwiki.fileSystemProvider.pageDir";
    public static final String FILE_EXT = ".txt";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private boolean m_windowsHackNeeded = false;
    private static final String[] WINDOWS_DEVICE_NAMES = new String[]{"con", "prn", "nul", "aux", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9"};

    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException, FileNotFoundException {
        log.debug((Object)"Initing FileSystemProvider");
        this.m_pageDirectory = WikiEngine.getRequiredProperty(properties, PROP_PAGEDIR);
        File f = new File(this.m_pageDirectory);
        if (!f.exists()) {
            if (!f.mkdirs()) {
                throw new IOException("Failed to create page directory " + f.getAbsolutePath() + " , please check property " + PROP_PAGEDIR);
            }
        } else {
            if (!f.isDirectory()) {
                throw new IOException("Page directory is not a directory: " + f.getAbsolutePath());
            }
            if (!f.canWrite()) {
                throw new IOException("Page directory is not writable: " + f.getAbsolutePath());
            }
        }
        this.m_engine = engine;
        this.m_encoding = properties.getProperty("jspwiki.encoding", DEFAULT_ENCODING);
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows") || os.equals("nt")) {
            this.m_windowsHackNeeded = true;
        }
        log.info((Object)("Wikipages are read from '" + this.m_pageDirectory + "'"));
    }

    String getPageDirectory() {
        return this.m_pageDirectory;
    }

    protected String mangleName(String pagename) {
        pagename = TextUtil.urlEncode(pagename, this.m_encoding);
        if ((pagename = TextUtil.replaceString(pagename, "/", "%2F")).startsWith(".")) {
            pagename = "%2E" + pagename.substring(1);
        }
        if (this.m_windowsHackNeeded) {
            String pn = pagename.toLowerCase();
            for (int i = 0; i < WINDOWS_DEVICE_NAMES.length; ++i) {
                if (!WINDOWS_DEVICE_NAMES[i].equals(pn)) continue;
                pagename = "$$$" + pagename;
            }
        }
        return pagename;
    }

    protected String unmangleName(String filename) {
        try {
            if (this.m_windowsHackNeeded && filename.startsWith("$$$") && filename.length() > 3) {
                filename = filename.substring(3);
            }
            return TextUtil.urlDecode(filename, this.m_encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalWikiException("Faulty encoding; should never happen");
        }
    }

    protected File findPage(String page) {
        return new File(this.m_pageDirectory, this.mangleName(page) + FILE_EXT);
    }

    public boolean pageExists(String page) {
        File pagefile = this.findPage(page);
        return pagefile.exists();
    }

    public String getPageText(String page, int version) throws ProviderException {
        return this.getPageText(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPageText(String page) {
        String result = null;
        FileInputStream in = null;
        File pagedata = this.findPage(page);
        if (pagedata.exists()) {
            if (pagedata.canRead()) {
                try {
                    in = new FileInputStream(pagedata);
                    result = FileUtil.readContents(in, this.m_encoding);
                }
                catch (IOException e) {
                    log.error((Object)"Failed to read", (Throwable)e);
                }
                finally {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (Exception e) {
                        log.fatal((Object)"Closing failed", (Throwable)e);
                    }
                }
            } else {
                log.warn((Object)("Failed to read page '" + page + "' from '" + pagedata.getAbsolutePath() + "', possibly a permissions problem"));
            }
        } else {
            log.info((Object)("New page '" + page + "'"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPageText(WikiPage page, String text) throws ProviderException {
        File file = this.findPage(page.getName());
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.m_encoding));
            out.print(text);
        }
        catch (IOException e) {
            log.error((Object)"Saving failed");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public Collection getAllPages() throws ProviderException {
        log.debug((Object)"Getting all pages...");
        ArrayList<WikiPage> set = new ArrayList<WikiPage>();
        File wikipagedir = new File(this.m_pageDirectory);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        if (wikipages == null) {
            log.error((Object)("Wikipages directory '" + this.m_pageDirectory + "' does not exist! Please check " + PROP_PAGEDIR + " in jspwiki.properties."));
            throw new InternalWikiException("Page directory does not exist");
        }
        for (int i = 0; i < wikipages.length; ++i) {
            int cutpoint;
            String wikiname = wikipages[i].getName();
            WikiPage page = this.getPageInfo(this.unmangleName(wikiname.substring(0, cutpoint = wikiname.lastIndexOf(FILE_EXT))), -1);
            if (page == null) {
                log.error((Object)("Page " + wikiname + " was found in directory listing, but could not be located individually."));
                continue;
            }
            set.add(page);
        }
        return set;
    }

    public Collection getAllChangedSince(Date date) {
        return new ArrayList();
    }

    public int getPageCount() {
        File wikipagedir = new File(this.m_pageDirectory);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        return wikipages.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findPages(QueryItem[] query) {
        File wikipagedir = new File(this.m_pageDirectory);
        TreeSet<SearchResult> res = new TreeSet<SearchResult>(new SearchResultComparator());
        SearchMatcher matcher = new SearchMatcher(this.m_engine, query);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        for (int i = 0; i < wikipages.length; ++i) {
            FileInputStream input2 = null;
            String filename = wikipages[i].getName();
            int cutpoint = filename.lastIndexOf(FILE_EXT);
            String wikiname = filename.substring(0, cutpoint);
            wikiname = this.unmangleName(wikiname);
            try {
                input2 = new FileInputStream(wikipages[i]);
                String pagetext = FileUtil.readContents(input2, this.m_encoding);
                SearchResult comparison = matcher.matchPageContent(wikiname, pagetext);
                if (comparison == null) continue;
                res.add(comparison);
                continue;
            }
            catch (IOException e) {
                log.error((Object)("Failed to read " + filename), (Throwable)e);
                continue;
            }
            finally {
                try {
                    if (input2 != null) {
                        input2.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return res;
    }

    public WikiPage getPageInfo(String page, int version) throws ProviderException {
        File file = this.findPage(page);
        if (!file.exists()) {
            return null;
        }
        WikiPage p = new WikiPage(this.m_engine, page);
        p.setLastModified(new Date(file.lastModified()));
        return p;
    }

    public List getVersionHistory(String page) throws ProviderException {
        ArrayList<WikiPage> list = new ArrayList<WikiPage>();
        list.add(this.getPageInfo(page, -1));
        return list;
    }

    public String getProviderInfo() {
        return "";
    }

    public void deleteVersion(String pageName, int version) throws ProviderException {
        if (version == -1) {
            File f = this.findPage(pageName);
            f.delete();
        }
    }

    public void deletePage(String pageName) throws ProviderException {
        File f = this.findPage(pageName);
        f.delete();
    }

    public static class WikiFileFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(AbstractFileProvider.FILE_EXT);
        }
    }
}

