/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Header;

public class HttpResponse {
    private int _statusCode;
    private String _statusLine;
    private int _maxRedirectsFollowed;
    private String _finalUri;
    private Map _responseHeaders;
    private String _body;
    private boolean _bodySizeExceeded = false;

    public HttpResponse(int statusCode, String statusLine, int redirectsFollowed, String finalUri, Header[] responseHeaders, String body) {
        this._statusCode = statusCode;
        this._statusLine = statusLine;
        this._maxRedirectsFollowed = redirectsFollowed;
        this._finalUri = finalUri;
        this._responseHeaders = new HashMap();
        if (responseHeaders != null) {
            for (int i = 0; i < responseHeaders.length; ++i) {
                String headerName = responseHeaders[i].getName().toLowerCase();
                Header header = responseHeaders[i];
                List headerList = (List)this._responseHeaders.get(headerName);
                if (headerList != null) {
                    headerList.add(responseHeaders[i]);
                    continue;
                }
                this._responseHeaders.put(headerName, new ArrayList<Header>(Arrays.asList(header)));
            }
        }
        this._body = body;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public String getStatusLine() {
        return this._statusLine;
    }

    public int getMaxRedirectsFollowed() {
        return this._maxRedirectsFollowed;
    }

    public String getFinalUri() {
        return this._finalUri;
    }

    public Header getResponseHeader(String headerName) {
        List headerList = (List)this._responseHeaders.get(headerName.toLowerCase());
        if (headerList != null && headerList.size() > 0) {
            return (Header)headerList.get(0);
        }
        return null;
    }

    public Header[] getResponseHeaders(String headerName) {
        List headerList = (List)this._responseHeaders.get(headerName.toLowerCase());
        if (headerList != null) {
            return headerList.toArray(new Header[headerList.size()]);
        }
        return new Header[0];
    }

    public String getBody() {
        return this._body;
    }

    public boolean isBodySizeExceeded() {
        return this._bodySizeExceeded;
    }

    public void setBodySizeExceeded(boolean bodySizeExceeded) {
        this._bodySizeExceeded = bodySizeExceeded;
    }
}

