/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.openid4java.consumer.ConsumerAssociationStore;

public class InMemoryConsumerAssociationStore
implements ConsumerAssociationStore {
    private static Log _log = LogFactory.getLog(InMemoryConsumerAssociationStore.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private Map _opMap = new HashMap();

    public synchronized void save(String opUrl, Association association) {
        this.removeExpired();
        HashMap<String, Association> handleMap = (HashMap<String, Association>)this._opMap.get(opUrl);
        if (handleMap == null) {
            handleMap = new HashMap<String, Association>();
            this._opMap.put(opUrl, handleMap);
        }
        String handle = association.getHandle();
        if (DEBUG) {
            _log.debug((Object)("Adding association to the in-memory store: " + handle + " with OP: " + opUrl));
        }
        handleMap.put(association.getHandle(), association);
    }

    public synchronized Association load(String opUrl, String handle) {
        Map handleMap;
        this.removeExpired();
        if (this._opMap.containsKey(opUrl) && (handleMap = (Map)this._opMap.get(opUrl)).containsKey(handle)) {
            return (Association)handleMap.get(handle);
        }
        return null;
    }

    public synchronized Association load(String opUrl) {
        this.removeExpired();
        Association latest = null;
        if (this._opMap.containsKey(opUrl)) {
            Map handleMap = (Map)this._opMap.get(opUrl);
            for (String handle : handleMap.keySet()) {
                Association association = (Association)handleMap.get(handle);
                if (latest != null && !latest.getExpiry().before(association.getExpiry())) continue;
                latest = association;
            }
        }
        return latest;
    }

    public synchronized void remove(String opUrl, String handle) {
        this.removeExpired();
        if (this._opMap.containsKey(opUrl)) {
            Map handleMap = (Map)this._opMap.get(opUrl);
            _log.info((Object)("Removing association: " + handle + " widh OP: " + opUrl));
            handleMap.remove(handle);
            if (handleMap.size() == 0) {
                this._opMap.remove(opUrl);
            }
        }
    }

    private synchronized void removeExpired() {
        HashSet<String> opToRemove = new HashSet<String>();
        for (String opUrl : this._opMap.keySet()) {
            Map handleMap = (Map)this._opMap.get(opUrl);
            HashSet<String> handleToRemove = new HashSet<String>();
            for (String handle : handleMap.keySet()) {
                Association association = (Association)handleMap.get(handle);
                if (!association.hasExpired()) continue;
                handleToRemove.add(handle);
            }
            for (String handle : handleToRemove) {
                _log.info((Object)("Removing expired association: " + handle + " with OP: " + opUrl));
                handleMap.remove(handle);
            }
            if (handleMap.size() != 0) continue;
            opToRemove.add(opUrl);
        }
        for (String opUrl : opToRemove) {
            this._opMap.remove(opUrl);
        }
    }

    protected synchronized int size() {
        int total = 0;
        for (String opUrl : this._opMap.keySet()) {
            Map handleMap = (Map)this._opMap.get(opUrl);
            total += handleMap.size();
        }
        return total;
    }
}

