/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.velocity.tools.struts.MessageResourcesTool;
import org.apache.velocity.tools.struts.StrutsUtils;

public class ActionMessagesTool
extends MessageResourcesTool {
    protected static final Log LOG = LogFactory.getLog((Class)ActionMessagesTool.class);
    protected ActionMessages actionMsgs;

    public void init(Object obj) {
        super.init(obj);
        this.actionMsgs = StrutsUtils.getMessages(this.request);
    }

    public boolean exist() {
        if (this.actionMsgs == null) {
            return false;
        }
        return !this.actionMsgs.isEmpty();
    }

    public boolean exist(String property) {
        if (this.actionMsgs == null) {
            return false;
        }
        return this.actionMsgs.size(property) > 0;
    }

    public int getSize() {
        if (this.actionMsgs == null) {
            return 0;
        }
        return this.actionMsgs.size();
    }

    public int getSize(String property) {
        if (this.actionMsgs == null) {
            return 0;
        }
        return this.actionMsgs.size(property);
    }

    public List getGlobal() {
        return this.get(this.getGlobalName());
    }

    public List getAll() {
        return this.get(null);
    }

    public List getAll(String bundle) {
        return this.get(null, bundle);
    }

    public List get(String property) {
        return this.get(property, null);
    }

    public List get(String property, String bundle) {
        if (this.actionMsgs == null || this.actionMsgs.isEmpty()) {
            return null;
        }
        Iterator msgs = property == null ? this.actionMsgs.get() : this.actionMsgs.get(property);
        if (!msgs.hasNext()) {
            return null;
        }
        MessageResources res = this.getResources(bundle);
        ArrayList<String> list = new ArrayList<String>();
        while (msgs.hasNext()) {
            ActionMessage msg = (ActionMessage)msgs.next();
            String message = null;
            if (res != null && msg.isResource() && (message = res.getMessage(this.locale, msg.getKey(), msg.getValues())) == null) {
                LOG.warn((Object)("Message for key " + msg.getKey() + " could not be found in message resources."));
            }
            if (message == null) {
                message = msg.getKey();
            }
            list.add(message);
        }
        return list;
    }

    public String getGlobalName() {
        return "org.apache.struts.action.GLOBAL_MESSAGE";
    }
}

