/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.engine.event.SearchEngineLifecycleEventListener;
import org.compass.core.lucene.engine.store.AbstractDirectoryStore;
import org.compass.core.lucene.engine.store.CopyFromHolder;
import org.compass.needle.terracotta.CSMTerracottaDirectory;
import org.compass.needle.terracotta.ManagedTerracottaDirectory;
import org.compass.needle.terracotta.TerracottaDirectory;

public class TerracottaDirectoryStore
extends AbstractDirectoryStore
implements CompassConfigurable {
    public static final String PROTOCOL = "tc://";
    public static final String BUFFER_SIZE_PROP = "compass.engine.store.tc.bufferSize";
    public static final String FLUSH_RATE_PROP = "compass.engine.store.tc.flushRate";
    public static final String CHM_INITIAL_CAPACITY_PROP = "compass.engine.store.tc.chm.initialCapacity";
    public static final String CHM_LOAD_FACTOR_PROP = "compass.engine.store.tc.chm.loadFactor";
    public static final String CHM_CONCURRENCY_LEVEL_PROP = "compass.engine.store.tc.chm.concurrencyLevel";
    public static final String TYPE = "compass.engine.store.tc.type";
    public static final String CONCURRENT = "compass.engine.store.tc.concurrent";
    private final Map<String, Map<String, Map<String, TerracottaDirectory>>> dirs = new HashMap<String, Map<String, Map<String, TerracottaDirectory>>>();
    private final ReadWriteLock managedRWL = new ReentrantReadWriteLock();
    private int bufferSize;
    private int flushRate;
    private int chmInitialCapacity;
    private float chmLoadFactor;
    private int chmConcurrencyLevel;
    private String type;
    private boolean managed;
    private boolean concurrent;
    private transient String indexName;

    public void configure(CompassSettings settings) throws CompassException {
        this.indexName = settings.getSetting("compass.engine.connection").substring(PROTOCOL.length());
        this.bufferSize = (int)settings.getSettingAsBytes(BUFFER_SIZE_PROP, 4096L);
        this.flushRate = settings.getSettingAsInt(FLUSH_RATE_PROP, 10);
        this.type = settings.getSetting(TYPE, "managed");
        this.managed = this.type.equals("managed");
        this.concurrent = settings.getSettingAsBoolean(CONCURRENT, false);
        if (this.managed) {
            this.concurrent = false;
        }
        this.chmInitialCapacity = settings.getSettingAsInt(CHM_CONCURRENCY_LEVEL_PROP, 160);
        this.chmLoadFactor = settings.getSettingAsFloat(CHM_LOAD_FACTOR_PROP, 0.75f);
        this.chmConcurrencyLevel = settings.getSettingAsInt(CHM_CONCURRENCY_LEVEL_PROP, 160);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Terracotta directory store configured with index [" + this.indexName + "], bufferSize [" + this.bufferSize + "], flushRate [" + this.flushRate + "], type [" + this.type + "], concurrent [" + this.concurrent + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory open(String subContext, String subIndex) throws SearchEngineException {
        Map<String, Map<String, Map<String, TerracottaDirectory>>> map = this.dirs;
        synchronized (map) {
            TerracottaDirectory dir;
            Map<String, TerracottaDirectory> subIndexDirs;
            Map<String, Map<String, TerracottaDirectory>> index = this.dirs.get(this.indexName);
            if (index == null) {
                index = new HashMap<String, Map<String, TerracottaDirectory>>();
                this.dirs.put(this.indexName, index);
            }
            if ((subIndexDirs = index.get(subContext)) == null) {
                subIndexDirs = new HashMap<String, TerracottaDirectory>();
                index.put(subContext, subIndexDirs);
            }
            if ((dir = subIndexDirs.get(subIndex)) == null) {
                if (this.type.equals("managed")) {
                    dir = new ManagedTerracottaDirectory(this.managedRWL, this.bufferSize, this.flushRate, this.chmInitialCapacity, this.chmLoadFactor, this.chmConcurrencyLevel);
                } else if (this.type.equals("csm")) {
                    dir = new CSMTerracottaDirectory(this.bufferSize, this.flushRate);
                } else if (this.type.equals("chm")) {
                    dir = new TerracottaDirectory(this.bufferSize, this.flushRate, this.chmInitialCapacity, this.chmLoadFactor, this.chmConcurrencyLevel);
                } else {
                    throw new ConfigurationException("No terracotta directory type [" + this.type + "]");
                }
                subIndexDirs.put(subIndex, dir);
            }
            return dir;
        }
    }

    public void cleanIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        this.deleteIndex(dir, subContext, subIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        Map<String, Map<String, Map<String, TerracottaDirectory>>> map = this.dirs;
        synchronized (map) {
            Map<String, Map<String, TerracottaDirectory>> index = this.dirs.get(this.indexName);
            if (index == null) {
                return;
            }
            Map<String, TerracottaDirectory> subIndexDirs = index.get(subContext);
            if (subIndexDirs != null) {
                subIndexDirs.remove(subIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listSubIndexes(String subContext) throws SearchEngineException, UnsupportedOperationException {
        Map<String, Map<String, Map<String, TerracottaDirectory>>> map = this.dirs;
        synchronized (map) {
            Map<String, Map<String, TerracottaDirectory>> index = this.dirs.get(this.indexName);
            if (index == null) {
                return null;
            }
            Map<String, TerracottaDirectory> subIndexDirs = index.get(subContext);
            if (subIndexDirs == null) {
                return null;
            }
            return subIndexDirs.keySet().toArray(new String[subIndexDirs.size()]);
        }
    }

    public CopyFromHolder beforeCopyFrom(String subContext, String subIndex, Directory dir) throws SearchEngineException {
        try {
            String[] files;
            for (String file : files = dir.list()) {
                dir.deleteFile(file);
            }
        }
        catch (IOException e) {
            throw new SearchEngineException("Faield to delete ram directory before copy", e);
        }
        return new CopyFromHolder();
    }

    public String suggestedIndexDeletionPolicy() {
        return "expirationtime";
    }

    public boolean supportsConcurrentCommits() {
        return this.concurrent;
    }

    public boolean supportsConcurrentOperations() {
        return this.concurrent;
    }

    public boolean requiresAsyncTransactionalContext() {
        return this.managed;
    }

    public void registerEventListeners(SearchEngine searchEngine, SearchEngineEventManager eventManager) {
        if (this.managed) {
            eventManager.registerLifecycleListener(new SearchEngineLifecycleEventListener(){

                public void beforeBeginTransaction() throws SearchEngineException {
                    TerracottaDirectoryStore.this.managedRWL.readLock().lock();
                }

                public void afterBeginTransaction() throws SearchEngineException {
                }

                public void afterPrepare() throws SearchEngineException {
                }

                public void afterCommit(boolean onePhase) throws SearchEngineException {
                    TerracottaDirectoryStore.this.managedRWL.readLock().unlock();
                }

                public void afterRollback() throws SearchEngineException {
                    try {
                        TerracottaDirectoryStore.this.managedRWL.readLock().unlock();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void close() throws SearchEngineException {
                }
            });
        }
    }
}

