/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.compass.core.config.ConfigurationException;
import org.compass.core.util.config.AbstractConfigurationHelper;
import org.compass.core.util.config.ConfigurationHelper;
import org.compass.core.util.config.ConfigurationHelperUtil;

public class PlainConfigurationHelper
extends AbstractConfigurationHelper
implements ConfigurationHelper,
Serializable {
    private static final long serialVersionUID = 3546076943545219376L;
    protected static final ConfigurationHelper[] EMPTY_ARRAY = new ConfigurationHelper[0];
    private final String name;
    private final String location;
    private final String namespace;
    private final String prefix;
    private HashMap<String, String> attributes;
    private ArrayList<ConfigurationHelper> children;
    private String value;
    private boolean readOnly;

    public PlainConfigurationHelper(String name) {
        this(name, null, "", "");
    }

    public PlainConfigurationHelper(String name, String location) {
        this(name, location, "", "");
    }

    public PlainConfigurationHelper(String name, String location, String ns, String prefix) {
        this.name = name;
        this.location = location;
        this.namespace = ns;
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() throws ConfigurationException {
        if (null != this.namespace) {
            return this.namespace;
        }
        throw new ConfigurationException("No namespace (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    protected String getPrefix() throws ConfigurationException {
        if (null != this.prefix) {
            return this.prefix;
        }
        throw new ConfigurationException("No prefix (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String getLocation() {
        return this.location;
    }

    public String getValue(String defaultValue) {
        if (null != this.value) {
            return this.value;
        }
        return defaultValue;
    }

    public String getAttributeOrValue(String paramName) {
        String retVal = this.getAttribute(paramName, null);
        if (retVal != null) {
            return retVal;
        }
        return this.getValue();
    }

    public String getValue() throws ConfigurationException {
        if (null != this.value) {
            return this.value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String[] getAttributeNames() {
        if (null == this.attributes) {
            return new String[0];
        }
        return this.attributes.keySet().toArray(new String[this.attributes.keySet().size()]);
    }

    public ConfigurationHelper[] getChildren() {
        if (null == this.children) {
            return new ConfigurationHelper[0];
        }
        return this.children.toArray(new ConfigurationHelper[this.children.size()]);
    }

    public String getAttribute(String name) throws ConfigurationException {
        String value;
        String string = value = null != this.attributes ? this.attributes.get(name) : null;
        if (null != value) {
            return value;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public ConfigurationHelper getChild(String name, boolean createNew) {
        if (null != this.children) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                ConfigurationHelper configuration = this.children.get(i);
                if (!name.equals(configuration.getName())) continue;
                return configuration;
            }
        }
        if (createNew) {
            return new PlainConfigurationHelper(name, "<generated>" + this.getLocation(), this.namespace, this.prefix);
        }
        return null;
    }

    public ConfigurationHelper[] getChildren(String name) {
        if (null == this.children) {
            return new ConfigurationHelper[0];
        }
        ArrayList<ConfigurationHelper> children = new ArrayList<ConfigurationHelper>();
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            ConfigurationHelper configuration = this.children.get(i);
            if (!name.equals(configuration.getName())) continue;
            children.add(configuration);
        }
        return children.toArray(new ConfigurationHelper[children.size()]);
    }

    public ConfigurationHelper[] getChildren(String ... names) {
        ArrayList<ConfigurationHelper> children = new ArrayList<ConfigurationHelper>();
        for (String name : names) {
            children.addAll(Arrays.asList(this.getChildren(name)));
        }
        return children.toArray(new ConfigurationHelper[children.size()]);
    }

    public void setValue(String value) {
        this.checkWriteable();
        this.value = value;
    }

    public void setValue(int value) {
        this.setValue(String.valueOf(value));
    }

    public void setValue(long value) {
        this.setValue(String.valueOf(value));
    }

    public void setValue(boolean value) {
        this.setValue(String.valueOf(value));
    }

    public void setValue(float value) {
        this.setValue(String.valueOf(value));
    }

    public void setAttribute(String name, String value) {
        this.checkWriteable();
        if (null != value) {
            if (null == this.attributes) {
                this.attributes = new HashMap();
            }
            this.attributes.put(name, value);
        } else if (null != this.attributes) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, long value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, float value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void addChild(ConfigurationHelper configuration) {
        this.checkWriteable();
        if (null == this.children) {
            this.children = new ArrayList();
        }
        this.children.add(configuration);
    }

    public void addAll(ConfigurationHelper other) {
        this.checkWriteable();
        this.setValue(other.getValue(null));
        this.addAllAttributes(other);
        this.addAllChildren(other);
    }

    public void addAllAttributes(ConfigurationHelper other) {
        String[] attributes;
        this.checkWriteable();
        for (String name : attributes = other.getAttributeNames()) {
            String value = other.getAttribute(name, null);
            this.setAttribute(name, value);
        }
    }

    public void addAllChildren(ConfigurationHelper other) {
        ConfigurationHelper[] children;
        this.checkWriteable();
        for (ConfigurationHelper aChildren : children = other.getChildren()) {
            this.addChild(aChildren);
        }
    }

    public void addAllChildrenBefore(ConfigurationHelper other) {
        this.checkWriteable();
        ConfigurationHelper[] children = other.getChildren();
        if (null == this.children) {
            this.children = new ArrayList();
        }
        for (int i = children.length - 1; i >= 0; --i) {
            this.children.add(0, children[i]);
        }
    }

    public void removeChild(ConfigurationHelper configuration) {
        this.checkWriteable();
        if (null == this.children) {
            return;
        }
        this.children.remove(configuration);
    }

    public int getChildCount() {
        if (null == this.children) {
            return 0;
        }
        return this.children.size();
    }

    public void makeReadOnly() {
        this.readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.readOnly) {
            throw new IllegalStateException("Configuration is read only and can not be modified");
        }
    }

    protected final boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ConfigurationHelper)) {
            return false;
        }
        return ConfigurationHelperUtil.equals(this, (ConfigurationHelper)other);
    }

    public int hashCode() {
        int hash = this.prefix.hashCode();
        if (this.name != null) {
            hash ^= this.name.hashCode();
        }
        hash >>>= 7;
        if (this.location != null) {
            hash ^= this.location.hashCode();
        }
        hash >>>= 7;
        if (this.namespace != null) {
            hash ^= this.namespace.hashCode();
        }
        hash >>>= 7;
        if (this.attributes != null) {
            hash ^= this.attributes.hashCode();
        }
        hash >>>= 7;
        if (this.children != null) {
            hash ^= this.children.hashCode();
        }
        hash >>>= 7;
        if (this.value != null) {
            hash ^= this.value.hashCode();
        }
        hash >>>= 7;
        return hash ^= this.readOnly ? 1 : 3;
    }
}

