/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.marshall;

import java.util.HashMap;
import java.util.Map;
import org.compass.core.ResourceFactory;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.marshall.MarshallingStrategy;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.spi.ResourceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMarshallingContext
implements MarshallingContext {
    private static final Object nullValue = new Object();
    private CompassMapping mapping;
    private SearchEngine searchEngine;
    private ConverterLookup converterLookup;
    private InternalCompassSession session;
    private MarshallingStrategy marshallingStrategy;
    private PropertyNamingStrategy propertyNamingStrategy;
    private Map<Object, Object> attributes = new HashMap<Object, Object>();
    private Map<PropertyPath, Object> nullValuesPath = new HashMap<PropertyPath, Object>();
    private Map<ResourceKey, Object> unmarshalled = new HashMap<ResourceKey, Object>();
    private Map<Object, Object> marshalled = new HashMap<Object, Object>();

    public DefaultMarshallingContext(CompassMapping mapping, SearchEngine searchEngine, ConverterLookup converterLookup, InternalCompassSession session, MarshallingStrategy marshallingStrategy) {
        this.mapping = mapping;
        this.searchEngine = searchEngine;
        this.converterLookup = converterLookup;
        this.session = session;
        this.marshallingStrategy = marshallingStrategy;
        this.propertyNamingStrategy = session.getCompass().getPropertyNamingStrategy();
    }

    @Override
    public void clearContext() {
        this.attributes.clear();
        this.nullValuesPath.clear();
        this.unmarshalled.clear();
        this.marshalled.clear();
    }

    @Override
    public void setUnmarshalled(ResourceKey key, Object obj) {
        this.unmarshalled.put(key, obj);
    }

    @Override
    public Object getUnmarshalled(ResourceKey key) {
        Object obj = this.session.getFirstLevelCache().get(key);
        if (obj != null) {
            return obj;
        }
        return this.unmarshalled.get(key);
    }

    @Override
    public void setMarshalled(Object key, Object value) {
        this.marshalled.put(key, value);
    }

    @Override
    public Object getMarshalled(Object key) {
        return this.marshalled.get(key);
    }

    @Override
    public void setHandleNulls(PropertyPath path) {
        this.nullValuesPath.put(path, nullValue);
    }

    @Override
    public void removeHandleNulls(PropertyPath path) {
        this.nullValuesPath.remove(path);
    }

    @Override
    public boolean handleNulls() {
        return this.nullValuesPath.size() > 0;
    }

    @Override
    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    @Override
    public ResourceFactory getResourceFactory() {
        return this.searchEngine.getSearchEngineFactory().getResourceFactory();
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    @Override
    public CompassMapping getCompassMapping() {
        return this.mapping;
    }

    @Override
    public InternalCompassSession getSession() {
        return this.session;
    }

    @Override
    public MarshallingStrategy getMarshallingStrategy() {
        return this.marshallingStrategy;
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    @Override
    public boolean hasAttribute(Object key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public Map<Object, Object> removeAttributes() {
        Map<Object, Object> retAttributes = this.attributes;
        this.attributes = new HashMap<Object, Object>();
        return retAttributes;
    }

    @Override
    public void restoreAttributes(Map<Object, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }
}

