/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.support;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;

public class CommitCallable
implements Callable {
    private static final Log logger = LogFactory.getLog(CommitCallable.class);
    private final LuceneSearchEngineIndexManager indexManager;
    private final String subIndex;
    private final IndexWriter indexWriter;
    private final boolean invalidateCacheOnCommit;

    public CommitCallable(LuceneSearchEngineIndexManager indexManager, String subIndex, IndexWriter indexWriter, boolean invalidateCacheOnCommit) {
        this.indexManager = indexManager;
        this.subIndex = subIndex;
        this.indexWriter = indexWriter;
        this.invalidateCacheOnCommit = invalidateCacheOnCommit;
    }

    public Object call() throws Exception {
        try {
            this.indexWriter.commit();
            this.indexWriter.close();
        }
        catch (IOException e) {
            Directory dir = this.indexManager.getStore().openDirectory(this.subIndex);
            try {
                if (IndexWriter.isLocked((Directory)dir)) {
                    IndexWriter.unlock((Directory)dir);
                }
            }
            catch (Exception e1) {
                logger.warn((Object)("Failed to check for locks or unlock failed commit for sub index [" + this.subIndex + "]"), (Throwable)e);
            }
            throw new SearchEngineException("Failed commit transaction sub index [" + this.subIndex + "]", e);
        }
        finally {
            this.indexManager.getIndexWritersManager().trackCloseIndexWriter(this.subIndex, this.indexWriter);
        }
        if (this.invalidateCacheOnCommit) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Invalidating cache after commit for sub index [" + this.subIndex + "]"));
            }
            this.indexManager.getIndexHoldersCache().invalidateCache(this.subIndex);
        }
        return null;
    }
}

