/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.executor.commonj;

import commonj.work.WorkException;
import commonj.work.WorkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.executor.commonj.WorkCallableFutureAdapter;
import org.compass.core.executor.commonj.WorkSubmitterCallable;
import org.compass.core.executor.commonj.WorkSubmitterRunnable;
import org.compass.core.executor.spi.InternalExecutorManager;
import org.compass.core.jndi.NamingHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkManagerExecutorManager
implements InternalExecutorManager,
CompassConfigurable {
    private WorkManager workManager;
    private ScheduledExecutorService executorService;

    @Override
    public void configure(CompassSettings settings) throws CompassException {
        String jndiName = settings.getSetting("compass.executorManager.commonj.workManagerJndiName");
        if (jndiName == null) {
            throw new ConfigurationException("When using WorkManager executor manager jndi name must be set using [compass.executorManager.workManager.jndiName]");
        }
        try {
            this.workManager = (WorkManager)NamingHelper.getInitialContext(settings).lookup(jndiName);
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to lookup workmanager under [" + jndiName + "]");
        }
        this.executorService = Executors.newScheduledThreadPool(1);
    }

    @Override
    public void submit(Runnable task) {
        this.submit(Executors.callable(task));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        WorkCallableFutureAdapter<T> workCallableAdapter = new WorkCallableFutureAdapter<T>(task);
        try {
            this.workManager.schedule(workCallableAdapter);
        }
        catch (WorkException e) {
            workCallableAdapter.setException((Exception)((Object)e));
        }
        return workCallableAdapter;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks) throws InterruptedException {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            futures.add(this.submit(task));
        }
        return futures;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        WorkSubmitterCallable<V> workSubmitterCallable = new WorkSubmitterCallable<V>(this.workManager, callable);
        return this.executorService.schedule(workSubmitterCallable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        WorkSubmitterRunnable workSubmitterRunnable = new WorkSubmitterRunnable(this.workManager, command);
        return this.executorService.scheduleAtFixedRate(workSubmitterRunnable, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        WorkSubmitterRunnable workSubmitterRunnable = new WorkSubmitterRunnable(this.workManager, command);
        return this.executorService.scheduleWithFixedDelay(workSubmitterRunnable, initialDelay, delay, unit);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }
}

