/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.accessor;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.compass.core.CompassException;
import org.compass.core.accessor.Getter;
import org.compass.core.accessor.PropertyAccessException;
import org.compass.core.accessor.PropertyAccessor;
import org.compass.core.accessor.PropertyNotFoundException;
import org.compass.core.accessor.Setter;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.reflection.ReflectionFactory;
import org.compass.core.util.reflection.ReflectionMethod;

public class BasicPropertyAccessor
implements PropertyAccessor,
CompassConfigurable {
    private CompassSettings settings;

    public void configure(CompassSettings settings) throws CompassException {
        this.settings = settings;
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this.getSetterOrNull(theClass, propertyName);
    }

    private BasicSetter getSetterOrNull(Class theClass, String propertyName) {
        if (theClass == Object.class || theClass == null) {
            return null;
        }
        Method method = this.setterMethod(theClass, propertyName);
        if (method != null) {
            if (!ClassUtils.isPublic(theClass, method)) {
                method.setAccessible(true);
            }
            try {
                return new BasicSetter(theClass, ReflectionFactory.getMethod(this.settings, method), propertyName);
            }
            catch (NoSuchMethodException e) {
                throw new PropertyAccessException(e, "Failed to get method for reflection", true, theClass, method.getName());
            }
        }
        BasicSetter setter = this.getSetterOrNull(theClass.getSuperclass(), propertyName);
        if (setter == null) {
            Class<?>[] interfaces = theClass.getInterfaces();
            for (int i = 0; setter == null && i < interfaces.length; ++i) {
                setter = this.getSetterOrNull(interfaces[i], propertyName);
            }
        }
        return setter;
    }

    private Method setterMethod(Class theClass, String propertyName) {
        BasicGetter getter = this.getGetterOrNull(theClass, propertyName);
        Class returnType = getter == null ? null : getter.getReturnType();
        Method[] methods = theClass.getDeclaredMethods();
        Method potentialSetter = null;
        for (Method method : methods) {
            String methodName = method.getName();
            if (method.getParameterTypes().length != 1 || !methodName.startsWith("set")) continue;
            String testStdMethod = Introspector.decapitalize(methodName.substring(3));
            String testOldMethod = methodName.substring(3);
            if (!testStdMethod.equals(propertyName) && !testOldMethod.equals(propertyName)) continue;
            potentialSetter = method;
            if (returnType != null && !method.getParameterTypes()[0].equals(returnType)) continue;
            return potentialSetter;
        }
        return potentialSetter;
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this.createGetter(theClass, propertyName);
    }

    public Getter createGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        BasicGetter result = this.getGetterOrNull(theClass, propertyName);
        if (result == null) {
            throw new PropertyNotFoundException("Could not find a getter for " + propertyName + " in class " + theClass.getName());
        }
        return result;
    }

    private BasicGetter getGetterOrNull(Class theClass, String propertyName) {
        if (theClass == Object.class || theClass == null) {
            return null;
        }
        Method method = this.getterMethod(theClass, propertyName);
        if (method != null) {
            if (!ClassUtils.isPublic(theClass, method)) {
                method.setAccessible(true);
            }
            try {
                return new BasicGetter(theClass, ReflectionFactory.getMethod(this.settings, method), propertyName);
            }
            catch (NoSuchMethodException e) {
                throw new PropertyAccessException(e, "Failed to get method for reflection", true, theClass, method.getName());
            }
        }
        BasicGetter getter = this.getGetterOrNull(theClass.getSuperclass(), propertyName);
        if (getter == null) {
            Class<?>[] interfaces = theClass.getInterfaces();
            for (int i = 0; getter == null && i < interfaces.length; ++i) {
                getter = this.getGetterOrNull(interfaces[i], propertyName);
            }
        }
        return getter;
    }

    private Method getterMethod(Class theClass, String propertyName) {
        try {
            return theClass.getMethod("get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return theClass.getMethod("is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                Method[] methods;
                for (Method method : methods = theClass.getDeclaredMethods()) {
                    String testOldMethod;
                    String testStdMethod;
                    if (method.getParameterTypes().length != 0) continue;
                    String methodName = method.getName();
                    if (methodName.startsWith("get")) {
                        testStdMethod = Introspector.decapitalize(methodName.substring(3));
                        testOldMethod = methodName.substring(3);
                        if (testStdMethod.equals(propertyName) || testOldMethod.equals(propertyName)) {
                            return method;
                        }
                    }
                    if (!methodName.startsWith("is")) continue;
                    testStdMethod = Introspector.decapitalize(methodName.substring(2));
                    testOldMethod = methodName.substring(2);
                    if (!testStdMethod.equals(propertyName) && !testOldMethod.equals(propertyName)) continue;
                    return method;
                }
                return null;
            }
        }
    }

    public static final class BasicGetter
    implements Getter {
        private static final long serialVersionUID = 3978701788020880176L;
        private Class clazz;
        private final transient ReflectionMethod method;
        private final String propertyName;

        private BasicGetter(Class clazz, ReflectionMethod method, String propertyName) {
            this.clazz = clazz;
            this.method = method;
            this.propertyName = propertyName;
        }

        public Object get(Object target) throws CompassException {
            try {
                return this.method.invoke(target, new Object[0]);
            }
            catch (InvocationTargetException ite) {
                throw new PropertyAccessException(ite, "Exception occurred inside", false, this.clazz, this.propertyName);
            }
            catch (IllegalAccessException iae) {
                throw new PropertyAccessException(iae, "IllegalAccessException occurred while calling", false, this.clazz, this.propertyName);
            }
            catch (IllegalArgumentException iae) {
                throw new PropertyAccessException(iae, "IllegalArgumentException occurred calling", false, this.clazz, this.propertyName);
            }
        }

        public String getName() {
            return this.propertyName;
        }

        public Class getReturnType() {
            return this.method.getReturnType();
        }

        public Type getGenericReturnType() {
            return this.method.getGenericReturnType();
        }

        public String toString() {
            return "BasicGetter(" + this.clazz.getName() + '.' + this.propertyName + ')';
        }
    }

    public static final class BasicSetter
    implements Setter {
        private static final long serialVersionUID = 3979266932753381168L;
        private Class clazz;
        private final transient ReflectionMethod method;
        private final String propertyName;

        private BasicSetter(Class clazz, ReflectionMethod method, String propertyName) {
            this.clazz = clazz;
            this.method = method;
            this.propertyName = propertyName;
        }

        public void set(Object target, Object value) throws CompassException {
            try {
                this.method.invoke(target, value);
            }
            catch (NullPointerException npe) {
                if (value == null && this.method.getParameterTypes()[0].isPrimitive()) {
                    throw new PropertyAccessException(npe, "Null value was assigned to a property of primitive type", true, this.clazz, this.propertyName);
                }
                throw new PropertyAccessException(npe, "NullPointerException occurred while calling", true, this.clazz, this.propertyName);
            }
            catch (InvocationTargetException ite) {
                throw new PropertyAccessException(ite, "Exception occurred inside", true, this.clazz, this.propertyName);
            }
            catch (IllegalAccessException iae) {
                throw new PropertyAccessException(iae, "IllegalAccessException occurred while calling", true, this.clazz, this.propertyName);
            }
            catch (IllegalArgumentException iae) {
                if (value == null && this.method.getParameterTypes()[0].isPrimitive()) {
                    throw new PropertyAccessException(iae, "Null value was assigned to a property of primitive type", true, this.clazz, this.propertyName);
                }
                throw new PropertyAccessException(iae, "IllegalArgumentException occurred while calling", true, this.clazz, this.propertyName);
            }
        }

        public String getName() {
            return this.propertyName;
        }

        public String getMethodName() {
            return this.method.getName();
        }

        public String toString() {
            return "BasicSetter(" + this.clazz.getName() + '.' + this.propertyName + ')';
        }
    }
}

