/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.util.servlet.NullSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedSessionWrapper
implements HttpSession {
    private static Log _log = LogFactoryUtil.getLog(SharedSessionWrapper.class);
    private HttpSession _session;
    private Map<String, Object> _sharedAttributes;

    public SharedSessionWrapper(HttpSession session) {
        this(session, new ConcurrentHashMap<String, Object>());
    }

    public SharedSessionWrapper(HttpSession session, Map<String, Object> sharedAttributes) {
        if (session == null) {
            this._session = new NullSession();
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Wrapped session is null");
            }
        } else {
            this._session = session;
        }
        this._sharedAttributes = sharedAttributes;
    }

    public Object getAttribute(String name) {
        Object value = this._session.getAttribute(name);
        if (value == null) {
            value = this._sharedAttributes.get(name);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        if (this._sharedAttributes.size() > 0) {
            Enumeration sessionAttributeNames = this._session.getAttributeNames();
            List names = null;
            Enumeration enumeration = sessionAttributeNames;
            synchronized (enumeration) {
                names = ListUtil.fromEnumeration((Enumeration)sessionAttributeNames);
            }
            names.addAll(this._sharedAttributes.keySet());
            return Collections.enumeration(names);
        }
        return this._session.getAttributeNames();
    }

    public long getCreationTime() {
        return this._session.getCreationTime();
    }

    public String getId() {
        return this._session.getId();
    }

    public long getLastAccessedTime() {
        return this._session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this._session.getMaxInactiveInterval();
    }

    public ServletContext getServletContext() {
        return this._session.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return this._session.getSessionContext();
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        List names = ListUtil.fromEnumeration(this.getAttributeNames());
        return names.toArray(new String[names.size()]);
    }

    public void invalidate() {
        this._session.invalidate();
    }

    public boolean isNew() {
        return this._session.isNew();
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this._session.removeAttribute(name);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this._session.setAttribute(name, value);
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this._session.setMaxInactiveInterval(maxInactiveInterval);
    }
}

