/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(WikiPageServiceHttp.class);

    public static WikiPage addPage(HttpPrincipal httpPrincipal, long nodeId, String title, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "addPage", new Class[]{Long.TYPE, String.class, String.class, String.class, Boolean.TYPE, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, content, summary, minorEdit, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiPage addPage(HttpPrincipal httpPrincipal, long nodeId, String title, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "addPage", new Class[]{Long.TYPE, String.class, String.class, String.class, Boolean.TYPE, String.class, String.class, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addPageAttachments(HttpPrincipal httpPrincipal, long nodeId, String title, List<ObjectValuePair<String, byte[]>> files) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "addPageAttachments", new Class[]{Long.TYPE, String.class, List.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, files});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void changeParent(HttpPrincipal httpPrincipal, long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "changeParent", new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, newParentTitle, serviceContext});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deletePage(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "deletePage", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deletePage(HttpPrincipal httpPrincipal, long nodeId, String title, double version) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "deletePage", new Class[]{Long.TYPE, String.class, Double.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, version});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deletePageAttachment(HttpPrincipal httpPrincipal, long nodeId, String title, String fileName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "deletePageAttachment", new Class[]{Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, fileName});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiPage getDraftPage(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "getDraftPage", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<WikiPage> getNodePages(HttpPrincipal httpPrincipal, long nodeId, int max) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "getNodePages", new Class[]{Long.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String getNodePagesRSS(HttpPrincipal httpPrincipal, long nodeId, int max, String type, double version, String displayStyle, String feedURL, String entryURL) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "getNodePagesRSS", new Class[]{Long.TYPE, Integer.TYPE, String.class, Double.TYPE, String.class, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, max, type, version, displayStyle, feedURL, entryURL});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiPage getPage(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "getPage", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiPage getPage(HttpPrincipal httpPrincipal, long nodeId, String title, Boolean head) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "getPage", new Class[]{Long.TYPE, String.class, Boolean.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, head});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiPage getPage(HttpPrincipal httpPrincipal, long nodeId, String title, double version) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "getPage", new Class[]{Long.TYPE, String.class, Double.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, version});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String getPagesRSS(HttpPrincipal httpPrincipal, long companyId, long nodeId, String title, int max, String type, double version, String displayStyle, String feedURL, String entryURL, Locale locale) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "getPagesRSS", new Class[]{Long.TYPE, Long.TYPE, String.class, Integer.TYPE, String.class, Double.TYPE, String.class, String.class, String.class, Locale.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, nodeId, title, max, type, version, displayStyle, feedURL, entryURL, locale});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void movePage(HttpPrincipal httpPrincipal, long nodeId, String title, String newTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "movePage", new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, newTitle, serviceContext});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiPage revertPage(HttpPrincipal httpPrincipal, long nodeId, String title, double version, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "revertPage", new Class[]{Long.TYPE, String.class, Double.TYPE, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, version, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void subscribePage(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "subscribePage", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsubscribePage(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "unsubscribePage", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiPage updatePage(HttpPrincipal httpPrincipal, long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class.getName(), "updatePage", new Class[]{Long.TYPE, String.class, Double.TYPE, String.class, String.class, Boolean.TYPE, String.class, String.class, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, version, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

