/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.ShoppingItemField;
import com.liferay.portlet.shopping.model.ShoppingItemPrice;
import com.liferay.portlet.shopping.service.ShoppingItemServiceUtil;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingItemServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ShoppingItemServiceHttp.class);

    public static void addBookItems(HttpPrincipal httpPrincipal, long groupId, long categoryId, String[] isbns) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingItemServiceUtil.class.getName(), "addBookItems", new Class[]{Long.TYPE, Long.TYPE, String[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, categoryId, isbns});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static ShoppingItem addItem(HttpPrincipal httpPrincipal, long groupId, long categoryId, String sku, String name, String description, String properties, String fieldsQuantities, boolean requiresShipping, int stockQuantity, boolean featured, Boolean sale, boolean smallImage, String smallImageURL, File smallFile, boolean mediumImage, String mediumImageURL, File mediumFile, boolean largeImage, String largeImageURL, File largeFile, List<ShoppingItemField> itemFields, List<ShoppingItemPrice> itemPrices, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingItemServiceUtil.class.getName(), "addItem", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, String.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.class, Boolean.TYPE, String.class, File.class, Boolean.TYPE, String.class, File.class, Boolean.TYPE, String.class, File.class, List.class, List.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, categoryId, sku, name, description, properties, fieldsQuantities, requiresShipping, stockQuantity, featured, sale, smallImage, smallImageURL, smallFile, mediumImage, mediumImageURL, mediumFile, largeImage, largeImageURL, largeFile, itemFields, itemPrices, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (ShoppingItem)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteItem(HttpPrincipal httpPrincipal, long itemId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingItemServiceUtil.class.getName(), "deleteItem", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{itemId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static ShoppingItem getItem(HttpPrincipal httpPrincipal, long itemId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingItemServiceUtil.class.getName(), "getItem", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{itemId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (ShoppingItem)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static ShoppingItem updateItem(HttpPrincipal httpPrincipal, long itemId, long groupId, long categoryId, String sku, String name, String description, String properties, String fieldsQuantities, boolean requiresShipping, int stockQuantity, boolean featured, Boolean sale, boolean smallImage, String smallImageURL, File smallFile, boolean mediumImage, String mediumImageURL, File mediumFile, boolean largeImage, String largeImageURL, File largeFile, List<ShoppingItemField> itemFields, List<ShoppingItemPrice> itemPrices, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ShoppingItemServiceUtil.class.getName(), "updateItem", new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, String.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.class, Boolean.TYPE, String.class, File.class, Boolean.TYPE, String.class, File.class, Boolean.TYPE, String.class, File.class, List.class, List.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{itemId, groupId, categoryId, sku, name, description, properties, fieldsQuantities, requiresShipping, stockQuantity, featured, sale, smallImage, smallImageURL, smallFile, mediumImage, mediumImageURL, mediumFile, largeImage, largeImageURL, largeFile, itemFields, itemPrices, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (ShoppingItem)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

