/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.NoSuchPortletItemException;
import com.liferay.portal.PortletItemNameException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.PortletPreferencesServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditArchivedSetupsAction
extends EditConfigurationAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("save")) {
                this.updateSetup(actionRequest, portlet);
                this.sendRedirect(actionRequest, actionResponse);
            } else if (cmd.equals("restore")) {
                this.restoreSetup(actionRequest, portlet);
                this.sendRedirect(actionRequest, actionResponse);
            } else if (cmd.equals("delete")) {
                this.deleteSetup(actionRequest);
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchPortletItemException || e instanceof PortletItemNameException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.sendRedirect(actionRequest, actionResponse);
            }
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.portlet_configuration.error");
        }
        renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_archived_setups"));
    }

    private void deleteSetup(ActionRequest actionRequest) throws Exception {
        long portletItemId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"portletItemId");
        PortletPreferencesServiceUtil.deleteArchivedPreferences((long)portletItemId);
    }

    private void restoreSetup(ActionRequest actionRequest, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        PortletPreferences setup = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portlet.getPortletId());
        PortletPreferencesServiceUtil.restoreArchivedPreferences((long)themeDisplay.getScopeGroupId(), (String)name, (String)portlet.getRootPortletId(), (PortletPreferences)setup);
    }

    protected void updateSetup(ActionRequest actionRequest, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        PortletPreferences setup = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portlet.getPortletId());
        PortletPreferencesServiceUtil.updateArchivePreferences((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (String)name, (String)portlet.getRootPortletId(), (PortletPreferences)setup);
    }
}

