/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.polls.DuplicateVoteException;
import com.liferay.portlet.polls.NoSuchQuestionException;
import com.liferay.portlet.polls.QuestionExpiredException;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.model.PollsVote;
import com.liferay.portlet.polls.service.base.PollsVoteLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollsVoteLocalServiceImpl
extends PollsVoteLocalServiceBaseImpl {
    public PollsVote addVote(long userId, long questionId, long choiceId, ServiceContext serviceContext) throws PortalException, SystemException {
        Date now = new Date();
        PollsChoice choice = this.pollsChoicePersistence.findByPrimaryKey(choiceId);
        if (choice.getQuestionId() != questionId) {
            throw new NoSuchQuestionException();
        }
        PollsQuestion question = this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        if (question.isExpired()) {
            throw new QuestionExpiredException();
        }
        question.setLastVoteDate(serviceContext.getCreateDate(now));
        this.pollsQuestionPersistence.update((BaseModel)question, false);
        PollsVote vote = this.pollsVotePersistence.fetchByQ_U(questionId, userId);
        if (vote != null) {
            throw new DuplicateVoteException();
        }
        long voteId = this.counterLocalService.increment();
        vote = this.pollsVotePersistence.create(voteId);
        vote.setUserId(userId);
        vote.setQuestionId(questionId);
        vote.setChoiceId(choiceId);
        vote.setVoteDate(serviceContext.getCreateDate(now));
        this.pollsVotePersistence.update((BaseModel)vote, false);
        return vote;
    }

    public List<PollsVote> getChoiceVotes(long choiceId, int start, int end) throws SystemException {
        return this.pollsVotePersistence.findByChoiceId(choiceId, start, end);
    }

    public int getChoiceVotesCount(long choiceId) throws SystemException {
        return this.pollsVotePersistence.countByChoiceId(choiceId);
    }

    public List<PollsVote> getQuestionVotes(long questionId, int start, int end) throws SystemException {
        return this.pollsVotePersistence.findByQuestionId(questionId, start, end);
    }

    public int getQuestionVotesCount(long questionId) throws SystemException {
        return this.pollsVotePersistence.countByQuestionId(questionId);
    }

    public PollsVote getVote(long questionId, long userId) throws PortalException, SystemException {
        return this.pollsVotePersistence.findByQ_U(questionId, userId);
    }
}

