/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.util.comparator.ArticleDisplayDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleModifiedDateComparator;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEnclosureImpl;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.feed.synd.SyndLinkImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalRSSUtil {
    private static Log _log = LogFactoryUtil.getLog(JournalRSSUtil.class);

    public static List<JournalArticle> getArticles(JournalFeed feed) throws SystemException {
        String templateId;
        String structureId;
        long companyId = feed.getCompanyId();
        long groupId = feed.getGroupId();
        String articleId = null;
        Double version = null;
        String title = null;
        String description = null;
        String content = null;
        String type = feed.getType();
        if (Validator.isNull((String)type)) {
            type = null;
        }
        if (Validator.isNull((String)(structureId = feed.getStructureId()))) {
            structureId = null;
        }
        if (Validator.isNull((String)(templateId = feed.getTemplateId()))) {
            templateId = null;
        }
        Date displayDateGT = null;
        Date displayDateLT = new Date();
        int status = 0;
        Date reviewDate = null;
        boolean andOperator = true;
        int start = 0;
        int end = feed.getDelta();
        String orderByCol = feed.getOrderByCol();
        String orderByType = feed.getOrderByType();
        boolean orderByAsc = orderByType.equals("asc");
        ArticleModifiedDateComparator obc = new ArticleModifiedDateComparator(orderByAsc);
        if (orderByCol.equals("display-date")) {
            obc = new ArticleDisplayDateComparator(orderByAsc);
        }
        return JournalArticleLocalServiceUtil.search((long)companyId, (long)groupId, articleId, version, title, description, content, (String)type, (String)structureId, (String)templateId, displayDateGT, (Date)displayDateLT, (int)status, reviewDate, (boolean)andOperator, (int)start, (int)end, (OrderByComparator)obc);
    }

    public static List<SyndEnclosure> getDLEnclosures(String portalURL, String url) {
        ArrayList<SyndEnclosure> enclosures = new ArrayList<SyndEnclosure>();
        DLFileEntry fileEntry = JournalRSSUtil.getDLFileEntry(url);
        if (fileEntry != null) {
            SyndEnclosureImpl enclosure = new SyndEnclosureImpl();
            enclosure.setLength(fileEntry.getSize());
            enclosure.setType(MimeTypesUtil.getContentType((String)fileEntry.getTitle()));
            enclosure.setUrl(String.valueOf(portalURL) + url);
            enclosures.add((SyndEnclosure)enclosure);
        }
        return enclosures;
    }

    public static DLFileEntry getDLFileEntry(String url) {
        DLFileEntry fileEntry;
        block7: {
            fileEntry = null;
            String queryString = HttpUtil.getQueryString((String)url);
            Map parameters = HttpUtil.parameterMapFromString((String)queryString);
            if (parameters.containsKey("folderId") && parameters.containsKey("name")) {
                try {
                    long groupId = GetterUtil.getLong((String)((String[])parameters.get("groupId"))[0]);
                    long folderId = GetterUtil.getLong((String)((String[])parameters.get("folderId"))[0]);
                    String name = ((String[])parameters.get("name"))[0];
                    fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)name);
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e, (Throwable)e);
                    }
                    break block7;
                }
            }
            if (parameters.containsKey("uuid") && parameters.containsKey("groupId")) {
                try {
                    String uuid = ((String[])parameters.get("uuid"))[0];
                    long groupId = GetterUtil.getLong((String)((String[])parameters.get("groupId"))[0]);
                    fileEntry = DLFileEntryLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
        }
        return fileEntry;
    }

    public static List<SyndLink> getDLLinks(String portalURL, String url) {
        ArrayList<SyndLink> links = new ArrayList<SyndLink>();
        DLFileEntry fileEntry = JournalRSSUtil.getDLFileEntry(url);
        if (fileEntry != null) {
            SyndLinkImpl link = new SyndLinkImpl();
            link.setHref(String.valueOf(portalURL) + url);
            link.setLength(fileEntry.getSize());
            link.setRel("enclosure");
            link.setType(MimeTypesUtil.getContentType((String)fileEntry.getTitle()));
            links.add((SyndLink)link);
        }
        return links;
    }

    public static List<SyndEnclosure> getIGEnclosures(String portalURL, String url) {
        ArrayList<SyndEnclosure> enclosures = new ArrayList<SyndEnclosure>();
        Image image = JournalRSSUtil.getImage(url);
        if (image != null) {
            SyndEnclosureImpl enclosure = new SyndEnclosureImpl();
            enclosure.setLength((long)image.getSize());
            enclosure.setType(MimeTypesUtil.getContentType((String)("*." + image.getType())));
            enclosure.setUrl(String.valueOf(portalURL) + url);
            enclosures.add((SyndEnclosure)enclosure);
        }
        return enclosures;
    }

    public static List<SyndLink> getIGLinks(String portalURL, String url) {
        ArrayList<SyndLink> links = new ArrayList<SyndLink>();
        Image image = JournalRSSUtil.getImage(url);
        if (image != null) {
            SyndLinkImpl link = new SyndLinkImpl();
            link.setHref(String.valueOf(portalURL) + url);
            link.setLength((long)image.getSize());
            link.setRel("enclosure");
            link.setType(MimeTypesUtil.getContentType((String)("*." + image.getType())));
            links.add((SyndLink)link);
        }
        return links;
    }

    public static Image getImage(String url) {
        Image image;
        block12: {
            image = null;
            String queryString = HttpUtil.getQueryString((String)url);
            Map parameters = HttpUtil.parameterMapFromString((String)queryString);
            if (parameters.containsKey("image_id") || parameters.containsKey("img_id") || parameters.containsKey("i_id")) {
                try {
                    long imageId = 0L;
                    if (parameters.containsKey("image_id")) {
                        imageId = GetterUtil.getLong((String)((String[])parameters.get("image_id"))[0]);
                    } else if (parameters.containsKey("img_id")) {
                        imageId = GetterUtil.getLong((String)((String[])parameters.get("img_id"))[0]);
                    } else if (parameters.containsKey("i_id")) {
                        imageId = GetterUtil.getLong((String)((String[])parameters.get("i_id"))[0]);
                    }
                    image = ImageLocalServiceUtil.getImage((long)imageId);
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e, (Throwable)e);
                    }
                    break block12;
                }
            }
            if (parameters.containsKey("uuid") && parameters.containsKey("groupId")) {
                try {
                    String uuid = ((String[])parameters.get("uuid"))[0];
                    long groupId = GetterUtil.getLong((String)((String[])parameters.get("groupId"))[0]);
                    IGImage igImage = IGImageLocalServiceUtil.getImageByUuidAndGroupId((String)uuid, (long)groupId);
                    image = ImageLocalServiceUtil.getImage((long)igImage.getLargeImageId());
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block12;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
        }
        return image;
    }
}

