/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandlerImpl;
import com.liferay.portlet.imagegallery.lar.IGPortletDataHandlerImpl;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.lar.JournalPortletDataHandlerImpl;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class JournalContentPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "journal";
    private static final boolean _PUBLISH_TO_LIVE_BY_DEFAULT = true;
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("journal", "comments");
    private static PortletDataHandlerBoolean _embeddedAssets = new PortletDataHandlerBoolean("journal", "embedded-assets");
    private static PortletDataHandlerBoolean _images = new PortletDataHandlerBoolean("journal", "images");
    private static Log _log = LogFactoryUtil.getLog(JournalContentPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("journal", "ratings");
    private static PortletDataHandlerBoolean _selectedArticles = new PortletDataHandlerBoolean("journal", "selected-web-content", true, true);
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("journal", "tags");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_selectedArticles, _embeddedAssets, _images, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_selectedArticles, _images, _comments, _ratings, _tags};
    }

    public boolean isPublishToLiveByDefault() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        preferences.setValue("group-id", "");
        preferences.setValue("article-id", "");
        return preferences;
    }

    protected String doExportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        String templateId;
        JournalArticle article;
        block13: {
            context.addPermissions("com.liferay.portlet.journal", context.getScopeGroupId());
            String articleId = preferences.getValue("article-id", null);
            if (articleId == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No article id found in preferences of portlet " + portletId));
                }
                return "";
            }
            long articleGroupId = GetterUtil.getLong((String)preferences.getValue("group-id", ""));
            if (articleGroupId <= 0L) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No group id found in preferences of portlet " + portletId));
                }
                return "";
            }
            article = null;
            try {
                article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleGroupId, (String)articleId, (int)0);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                if (!_log.isWarnEnabled()) break block13;
                _log.warn((Object)("No approved article found with group id " + articleGroupId + " and article id " + articleId));
            }
        }
        if (article == null) {
            return "";
        }
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("journal-content-data");
        String path = JournalPortletDataHandlerImpl.getArticlePath(context, article);
        Element articleElement = rootElement.addElement("article");
        articleElement.addAttribute("path", path);
        Element dlFoldersElement = rootElement.addElement("dl-folders");
        Element dlFilesElement = rootElement.addElement("dl-file-entries");
        Element dlFileRanksElement = rootElement.addElement("dl-file-ranks");
        Element igFoldersElement = rootElement.addElement("ig-folders");
        Element igImagesElement = rootElement.addElement("ig-images");
        JournalPortletDataHandlerImpl.exportArticle(context, rootElement, rootElement, rootElement, dlFoldersElement, dlFilesElement, dlFileRanksElement, igFoldersElement, igImagesElement, article, false);
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)article.getCompanyId());
        String structureId = article.getStructureId();
        if (Validator.isNotNull((String)structureId)) {
            JournalStructure structure = null;
            try {
                structure = JournalStructureLocalServiceUtil.getStructure((long)article.getGroupId(), (String)structureId);
            }
            catch (NoSuchStructureException noSuchStructureException) {
                structure = JournalStructureLocalServiceUtil.getStructure((long)companyGroup.getGroupId(), (String)structureId);
            }
            JournalPortletDataHandlerImpl.exportStructure(context, rootElement, structure);
        }
        if (Validator.isNotNull((String)(templateId = article.getTemplateId()))) {
            JournalTemplate template = null;
            try {
                template = JournalTemplateLocalServiceUtil.getTemplate((long)context.getScopeGroupId(), (String)templateId);
            }
            catch (NoSuchTemplateException noSuchTemplateException) {
                template = JournalTemplateLocalServiceUtil.getTemplate((long)companyGroup.getGroupId(), (String)templateId);
            }
            JournalPortletDataHandlerImpl.exportTemplate(context, rootElement, dlFoldersElement, dlFilesElement, dlFileRanksElement, igFoldersElement, igImagesElement, template, false);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws Exception {
        String articleId;
        Element articleElement;
        Element templateElement;
        context.importPermissions("com.liferay.portlet.journal", context.getSourceGroupId(), context.getScopeGroupId());
        if (Validator.isNull((String)data)) {
            return null;
        }
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element dlFoldersElement = rootElement.element("dl-folders");
        List dlFolderElements = Collections.EMPTY_LIST;
        if (dlFoldersElement != null) {
            dlFolderElements = dlFoldersElement.elements("folder");
        }
        for (Element folderElement : dlFolderElements) {
            DLPortletDataHandlerImpl.importFolder(context, folderElement);
        }
        Element dlFileEntriesElement = rootElement.element("dl-file-entries");
        List dlFileEntryElements = Collections.EMPTY_LIST;
        if (dlFileEntriesElement != null) {
            dlFileEntryElements = dlFileEntriesElement.elements("file-entry");
        }
        for (Element fileEntryElement : dlFileEntryElements) {
            DLPortletDataHandlerImpl.importFileEntry(context, fileEntryElement);
        }
        Element dlFileRanksElement = rootElement.element("dl-file-ranks");
        List dlFileRankElements = Collections.EMPTY_LIST;
        if (dlFileRanksElement != null) {
            dlFileRankElements = dlFileRanksElement.elements("file-rank");
        }
        for (Element fileRankElement : dlFileRankElements) {
            DLPortletDataHandlerImpl.importFileRank(context, fileRankElement);
        }
        Element igFoldersElement = rootElement.element("ig-folders");
        List igFolderElements = Collections.EMPTY_LIST;
        if (igFoldersElement != null) {
            igFolderElements = igFoldersElement.elements("folder");
        }
        for (Element folderElement : igFolderElements) {
            IGPortletDataHandlerImpl.importFolder(context, folderElement);
        }
        Element igImagesElement = rootElement.element("ig-images");
        List igImageElements = Collections.EMPTY_LIST;
        if (igImagesElement != null) {
            igImageElements = igImagesElement.elements("image");
        }
        for (Element imageElement : igImageElements) {
            IGPortletDataHandlerImpl.importImage(context, imageElement);
        }
        Element structureElement = rootElement.element("structure");
        if (structureElement != null) {
            JournalPortletDataHandlerImpl.importStructure(context, structureElement);
        }
        if ((templateElement = rootElement.element("template")) != null) {
            JournalPortletDataHandlerImpl.importTemplate(context, templateElement);
        }
        if ((articleElement = rootElement.element("article")) != null) {
            JournalPortletDataHandlerImpl.importArticle(context, articleElement);
        }
        if (Validator.isNotNull((String)(articleId = preferences.getValue("article-id", "")))) {
            Map articleIds = context.getNewPrimaryKeysMap(JournalArticle.class);
            articleId = MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId);
            preferences.setValue("group-id", String.valueOf(context.getScopeGroupId()));
            preferences.setValue("article-id", articleId);
            Layout layout = LayoutLocalServiceUtil.getLayout((long)context.getPlid());
            JournalContentSearchLocalServiceUtil.updateContentSearch((long)context.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)articleId, (boolean)true);
        }
        return preferences;
    }
}

