/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.asset.JournalArticleAssetRenderer;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import javax.portlet.PortletURL;

public class JournalArticleAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String CLASS_NAME = JournalArticle.class.getName();
    public static final String TYPE = "content";

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        JournalArticle article = null;
        try {
            article = JournalArticleLocalServiceUtil.getArticle((long)classPK);
        }
        catch (NoSuchArticleException noSuchArticleException) {
            JournalArticleResource articleResource = JournalArticleResourceLocalServiceUtil.getArticleResource((long)classPK);
            int status = -1;
            if (type == 1) {
                status = 0;
            }
            article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleResource.getGroupId(), (String)articleResource.getArticleId(), (int)status);
        }
        return new JournalArticleAssetRenderer(article);
    }

    public AssetRenderer getAssetRenderer(long groupId, String urlTitle) throws PortalException, SystemException {
        JournalArticle article = JournalArticleServiceUtil.getArticleByUrlTitle((long)groupId, (String)urlTitle);
        return new JournalArticleAssetRenderer(article);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        LiferayPortletURL addAssetURL = null;
        if (JournalPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_ARTICLE")) {
            addAssetURL = liferayPortletResponse.createRenderURL("15");
            addAssetURL.setParameter("struts_action", "/journal/edit_article");
            addAssetURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
        }
        return addAssetURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return JournalArticlePermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/history.png";
    }
}

