/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.base.IGFolderServiceBaseImpl;
import com.liferay.portlet.imagegallery.service.permission.IGFolderPermission;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGFolderServiceImpl
extends IGFolderServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(IGFolderServiceImpl.class);

    public IGFolder addFolder(long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        IGFolderPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentFolderId, "ADD_FOLDER");
        return this.igFolderLocalService.addFolder(this.getUserId(), parentFolderId, name, description, serviceContext);
    }

    public IGFolder copyFolder(long sourceFolderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        IGFolder srcFolder = this.getFolder(sourceFolderId);
        IGFolder destFolder = this.addFolder(parentFolderId, name, description, serviceContext);
        this.copyFolder(srcFolder, destFolder, serviceContext);
        return destFolder;
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        IGFolder folder = this.igFolderLocalService.getFolder(folderId);
        IGFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        this.igFolderLocalService.deleteFolder(folderId);
    }

    public IGFolder getFolder(long folderId) throws PortalException, SystemException {
        IGFolder folder = this.igFolderLocalService.getFolder(folderId);
        IGFolderPermission.check(this.getPermissionChecker(), folder, "VIEW");
        return folder;
    }

    public IGFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        IGFolder folder = this.igFolderLocalService.getFolder(groupId, parentFolderId, name);
        IGFolderPermission.check(this.getPermissionChecker(), folder, "VIEW");
        return folder;
    }

    public List<IGFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.igFolderPersistence.filterFindByG_P(groupId, parentFolderId);
    }

    public List<IGFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.igFolderPersistence.filterFindByG_P(groupId, parentFolderId, start, end);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.igFolderPersistence.filterCountByG_P(groupId, parentFolderId);
    }

    public IGFolder updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        IGFolder folder = this.igFolderLocalService.getFolder(folderId);
        IGFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        return this.igFolderLocalService.updateFolder(folderId, parentFolderId, name, description, mergeWithParentFolder, serviceContext);
    }

    protected void copyFolder(IGFolder srcFolder, IGFolder destFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        List srcImages = this.igImageService.getImages(srcFolder.getGroupId(), srcFolder.getFolderId());
        for (IGImage srcImage : srcImages) {
            String name = srcImage.getName();
            String description = srcImage.getDescription();
            File file = null;
            try {
                file = FileUtil.createTempFile((String)srcImage.getImageType());
                Image image = this.imageLocalService.getImage(srcImage.getLargeImageId());
                byte[] bytes = image.getTextObj();
                FileUtil.write((File)file, (byte[])bytes);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                continue;
            }
            String contentType = MimeTypesUtil.getContentType((String)srcImage.getImageType());
            this.igImageService.addImage(destFolder.getGroupId(), destFolder.getFolderId(), name, description, file, contentType, serviceContext);
            file.delete();
        }
        List<IGFolder> srcSubfolders = this.getFolders(srcFolder.getGroupId(), srcFolder.getFolderId());
        for (IGFolder srcSubfolder : srcSubfolders) {
            String name = srcSubfolder.getName();
            String description = srcSubfolder.getDescription();
            serviceContext.setScopeGroupId(srcFolder.getGroupId());
            IGFolder destSubfolder = this.addFolder(destFolder.getFolderId(), name, description, serviceContext);
            this.copyFolder(srcSubfolder, destSubfolder, serviceContext);
        }
    }
}

