/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.permission.IGImagePermission;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public class IGImageAssetRenderer
extends BaseAssetRenderer {
    private IGImage _image;

    public IGImageAssetRenderer(IGImage image) {
        this._image = image;
    }

    public long getClassPK() {
        return this._image.getImageId();
    }

    public long getGroupId() {
        return this._image.getGroupId();
    }

    public String getSummary() {
        return HtmlUtil.stripHtml((String)this._image.getDescription());
    }

    public String getTitle() {
        return this._image.getName();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        LiferayPortletURL editPortletURL = liferayPortletResponse.createRenderURL("31");
        editPortletURL.setParameter("struts_action", "/image_gallery/edit_image");
        editPortletURL.setParameter("folderId", String.valueOf(this._image.getFolderId()));
        editPortletURL.setParameter("imageId", String.valueOf(this._image.getImageId()));
        return editPortletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) throws Exception {
        LiferayPortletURL viewPortletURL = liferayPortletResponse.createRenderURL("31");
        viewPortletURL.setWindowState(WindowState.MAXIMIZED);
        viewPortletURL.setParameter("struts_action", "/image_gallery/view");
        viewPortletURL.setParameter("groupId", String.valueOf(this._image.getGroupId()));
        viewPortletURL.setParameter("folderId", String.valueOf(this._image.getFolderId()));
        return viewPortletURL.toString();
    }

    public long getUserId() {
        return this._image.getUserId();
    }

    public String getUuid() {
        return this._image.getUuid();
    }

    public String getViewInContextMessage() {
        return "view-album";
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        return IGImagePermission.contains(permissionChecker, this._image, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        return IGImagePermission.contains(permissionChecker, this._image, "VIEW");
    }

    public boolean isPrintable() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("IMAGE_GALLERY_IMAGE", (Object)this._image);
            return "/html/portlet/image_gallery/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/file_system/small/bmp.png";
    }
}

