/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoValue;
import com.liferay.portlet.expando.service.base.ExpandoValueServiceBaseImpl;
import com.liferay.portlet.expando.service.permission.ExpandoColumnPermission;
import java.io.Serializable;

public class ExpandoValueServiceImpl
extends ExpandoValueServiceBaseImpl {
    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Object data) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        ExpandoColumnPermission.check(this.getPermissionChecker(), column, "UPDATE");
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, String data) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        ExpandoColumnPermission.check(this.getPermissionChecker(), column, "UPDATE");
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public Serializable getData(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        if (ExpandoColumnPermission.contains(this.getPermissionChecker(), column, "VIEW")) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK);
        }
        return null;
    }

    public JSONObject getJSONData(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        if (ExpandoColumnPermission.contains(this.getPermissionChecker(), column, "VIEW")) {
            String data = this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, "");
            if (Validator.isNotNull((String)data)) {
                return JSONFactoryUtil.createJSONObject((String)data);
            }
            return null;
        }
        return null;
    }
}

