/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.webdav;

import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import java.io.InputStream;

public class DLFileEntryResourceImpl
extends BaseResourceImpl {
    private WebDAVRequest _webDavRequest;
    private DLFileEntry _fileEntry;

    public DLFileEntryResourceImpl(WebDAVRequest webDavRequest, DLFileEntry fileEntry, String parentPath, String name) {
        super(parentPath, name, fileEntry.getTitle(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getSize());
        this.setModel(fileEntry);
        this.setClassName(DLFileEntry.class.getName());
        this.setPrimaryKey(fileEntry.getPrimaryKey());
        this._webDavRequest = webDavRequest;
        this._fileEntry = fileEntry;
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isLocked() {
        try {
            return DLFileEntryServiceUtil.hasFileEntryLock((long)this._fileEntry.getGroupId(), (long)this._fileEntry.getFolderId(), (String)this._fileEntry.getName());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getContentType() {
        return MimeTypesUtil.getContentType((String)this._fileEntry.getTitle());
    }

    public InputStream getContentAsStream() throws WebDAVException {
        try {
            String version = "";
            if (PropsValues.DL_WEBDAV_HOLD_LOCK) {
                DLFileVersion fileVersion = DLFileVersionLocalServiceUtil.getLatestFileVersion((long)this._fileEntry.getGroupId(), (long)this._fileEntry.getFolderId(), (String)this._fileEntry.getName());
                version = fileVersion.getVersion();
            }
            return DLFileEntryLocalServiceUtil.getFileAsStream((long)this._webDavRequest.getCompanyId(), (long)this._webDavRequest.getUserId(), (long)this._fileEntry.getGroupId(), (long)this._fileEntry.getFolderId(), (String)this._fileEntry.getName(), (String)version);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }
}

