/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.impl;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.EntryContentException;
import com.liferay.portlet.blogs.EntryDisplayDateException;
import com.liferay.portlet.blogs.EntryTitleException;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.base.BlogsEntryLocalServiceBaseImpl;
import com.liferay.portlet.blogs.util.BlogsUtil;
import com.liferay.portlet.blogs.util.LinkbackProducerUtil;
import com.liferay.portlet.blogs.util.comparator.EntryDisplayDateComparator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsEntryLocalServiceImpl
extends BlogsEntryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(BlogsEntryLocalServiceImpl.class);

    public BlogsEntry addEntry(long userId, String title, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new EntryDisplayDateException());
        Date now = new Date();
        this.validate(title, content);
        long entryId = this.counterLocalService.increment();
        BlogsEntry entry = this.blogsEntryPersistence.create(entryId);
        entry.setUuid(serviceContext.getUuid());
        entry.setGroupId(groupId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setCreateDate(serviceContext.getCreateDate(now));
        entry.setModifiedDate(serviceContext.getModifiedDate(now));
        entry.setTitle(title);
        entry.setUrlTitle(this.getUniqueUrlTitle(entryId, groupId, title));
        entry.setContent(content);
        entry.setDisplayDate(displayDate);
        entry.setAllowPingbacks(allowPingbacks);
        entry.setAllowTrackbacks(allowTrackbacks);
        entry.setStatus(2);
        entry.setStatusDate(serviceContext.getModifiedDate(now));
        entry.setExpandoBridgeAttributes(serviceContext);
        this.blogsEntryPersistence.update((BaseModel)entry, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addEntryResources(entry, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addEntryResources(entry, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        if (PropsValues.BLOGS_ENTRY_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, entry.getUserName(), groupId, BlogsEntry.class.getName(), entryId, 1);
        }
        if (trackbacks != null && trackbacks.length > 0) {
            serviceContext.setAttribute("trackbacks", (Serializable)trackbacks);
        } else {
            serviceContext.setAttribute("trackbacks", null);
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (Object)entry, (ServiceContext)serviceContext);
        return entry;
    }

    public void addEntryResources(BlogsEntry entry, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BlogsEntry.class.getName(), entry.getEntryId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addEntryResources(BlogsEntry entry, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BlogsEntry.class.getName(), entry.getEntryId(), communityPermissions, guestPermissions);
    }

    public void addEntryResources(long entryId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, addCommunityPermissions, addGuestPermissions);
    }

    public void addEntryResources(long entryId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, communityPermissions, guestPermissions);
    }

    public void deleteEntries(long groupId) throws PortalException, SystemException {
        for (BlogsEntry entry : this.blogsEntryPersistence.findByGroupId(groupId)) {
            this.deleteEntry(entry);
        }
    }

    public void deleteEntry(BlogsEntry entry) throws PortalException, SystemException {
        this.blogsEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource(entry.getCompanyId(), BlogsEntry.class.getName(), 4, entry.getEntryId());
        this.blogsStatsUserLocalService.updateStatsUser(entry.getGroupId(), entry.getUserId());
        this.assetEntryLocalService.deleteEntry(BlogsEntry.class.getName(), entry.getEntryId());
        this.expandoValueLocalService.deleteValues(BlogsEntry.class.getName(), entry.getEntryId());
        this.mbMessageLocalService.deleteDiscussionMessages(BlogsEntry.class.getName(), entry.getEntryId());
        this.ratingsStatsLocalService.deleteStats(BlogsEntry.class.getName(), entry.getEntryId());
        this.socialActivityLocalService.deleteActivities(BlogsEntry.class.getName(), entry.getEntryId());
        Indexer indexer = IndexerRegistryUtil.getIndexer(BlogsEntry.class);
        indexer.delete((Object)entry);
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId());
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByC_LtD(companyId, new Date(), start, end);
        }
        return this.blogsEntryPersistence.findByC_LtD_S(companyId, new Date(), status, start, end);
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByC_LtD(companyId, new Date(), start, end, obc);
        }
        return this.blogsEntryPersistence.findByC_LtD_S(companyId, new Date(), status, start, end, obc);
    }

    public int getCompanyEntriesCount(long companyId, int status) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.countByC_LtD(companyId, new Date());
        }
        return this.blogsEntryPersistence.countByC_LtD_S(companyId, new Date(), status);
    }

    public BlogsEntry[] getEntriesPrevAndNext(long entryId) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        return this.blogsEntryPersistence.findByG_S_PrevAndNext(entry.getEntryId(), entry.getGroupId(), 0, (OrderByComparator)new EntryDisplayDateComparator(true));
    }

    public BlogsEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.blogsEntryPersistence.findByPrimaryKey(entryId);
    }

    public BlogsEntry getEntry(long groupId, String urlTitle) throws PortalException, SystemException {
        return this.blogsEntryPersistence.findByG_UT(groupId, urlTitle);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByG_LtD(groupId, new Date(), start, end);
        }
        return this.blogsEntryPersistence.findByG_LtD_S(groupId, new Date(), status, start, end);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByG_LtD(groupId, new Date(), start, end, obc);
        }
        return this.blogsEntryPersistence.findByG_LtD_S(groupId, new Date(), status, start, end, obc);
    }

    public int getGroupEntriesCount(long groupId, int status) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.countByG_LtD(groupId, new Date());
        }
        return this.blogsEntryPersistence.countByG_LtD_S(groupId, new Date(), status);
    }

    public List<BlogsEntry> getGroupsEntries(long companyId, long groupId, int status, int start, int end) throws SystemException {
        return this.blogsEntryFinder.findByGroupIds(companyId, groupId, status, start, end);
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByG_U_LtD(groupId, userId, new Date(), start, end);
        }
        return this.blogsEntryPersistence.findByG_U_LtD_S(groupId, userId, new Date(), status, start, end);
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByG_U_LtD(groupId, userId, new Date(), start, end, obc);
        }
        return this.blogsEntryPersistence.findByG_U_LtD_S(groupId, userId, new Date(), status, start, end, obc);
    }

    public int getGroupUserEntriesCount(long groupId, long userId, int status) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.countByG_U_LtD(groupId, userId, new Date());
        }
        return this.blogsEntryPersistence.countByG_U_LtD_S(groupId, userId, new Date(), status);
    }

    public List<BlogsEntry> getNoAssetEntries() throws SystemException {
        return this.blogsEntryFinder.findByNoAssets();
    }

    public List<BlogsEntry> getOrganizationEntries(long organizationId, int status, int start, int end) throws SystemException {
        return this.blogsEntryFinder.findByOrganizationId(organizationId, new Date(), status, start, end);
    }

    public int getOrganizationEntriesCount(long organizationId, int status) throws SystemException {
        return this.blogsEntryFinder.countByOrganizationId(organizationId, new Date(), status);
    }

    public void updateAsset(long userId, BlogsEntry entry, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        boolean visible = false;
        if (entry.getStatus() == 0) {
            visible = true;
        }
        String summary = HtmlUtil.extractText((String)StringUtil.shorten((String)entry.getContent(), (int)500));
        this.assetEntryLocalService.updateEntry(userId, entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), entry.getUuid(), assetCategoryIds, assetTagNames, visible, null, null, entry.getDisplayDate(), null, "text/html", entry.getTitle(), null, summary, null, 0, 0, null, false);
    }

    public BlogsEntry updateEntry(long userId, long entryId, String title, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new EntryDisplayDateException());
        this.validate(title, content);
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        String oldUrlTitle = entry.getUrlTitle();
        entry.setModifiedDate(serviceContext.getModifiedDate(null));
        entry.setTitle(title);
        entry.setUrlTitle(this.getUniqueUrlTitle(entryId, entry.getGroupId(), title));
        entry.setContent(content);
        entry.setDisplayDate(displayDate);
        entry.setAllowPingbacks(allowPingbacks);
        entry.setAllowTrackbacks(allowTrackbacks);
        entry.setExpandoBridgeAttributes(serviceContext);
        this.blogsEntryPersistence.update((BaseModel)entry, false);
        if (serviceContext.getCommunityPermissions() != null || serviceContext.getGuestPermissions() != null) {
            this.updateEntryResources(entry, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        boolean pingOldTrackbacks = false;
        if (!oldUrlTitle.equals(entry.getUrlTitle())) {
            pingOldTrackbacks = true;
        }
        serviceContext.setAttribute("pingOldTrackbacks", (Serializable)((Object)String.valueOf(pingOldTrackbacks)));
        if (Validator.isNotNull((Object[])trackbacks)) {
            serviceContext.setAttribute("trackbacks", (Serializable)trackbacks);
        } else {
            serviceContext.setAttribute("trackbacks", null);
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)entry.getGroupId(), (long)userId, (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (Object)entry, (ServiceContext)serviceContext);
        return entry;
    }

    public void updateEntryResources(BlogsEntry entry, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.updateResources(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), communityPermissions, guestPermissions);
    }

    public BlogsEntry updateStatus(long userId, long entryId, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        int oldStatus = entry.getStatus();
        entry.setModifiedDate(serviceContext.getModifiedDate(now));
        entry.setStatus(status);
        entry.setStatusByUserId(user.getUserId());
        entry.setStatusByUserName(user.getFullName());
        entry.setStatusDate(serviceContext.getModifiedDate(now));
        this.blogsEntryPersistence.update((BaseModel)entry, false);
        Indexer indexer = IndexerRegistryUtil.getIndexer(BlogsEntry.class);
        if (status == 0) {
            this.blogsStatsUserLocalService.updateStatsUser(entry.getGroupId(), entry.getUserId(), entry.getDisplayDate());
            if (oldStatus != 0) {
                this.assetEntryLocalService.updateVisible(BlogsEntry.class.getName(), entryId, true);
                this.socialActivityLocalService.addUniqueActivity(entry.getUserId(), entry.getGroupId(), BlogsEntry.class.getName(), entryId, 2, "", 0L);
                this.socialEquityLogLocalService.addEquityLogs(userId, BlogsEntry.class.getName(), entryId, "ADD_ENTRY");
                this.notifySubscribers(entry, serviceContext);
            }
            indexer.reindex((Object)entry);
            String[] trackbacks = (String[])serviceContext.getAttribute("trackbacks");
            Boolean pingOldTrackbacks = GetterUtil.getBoolean((String)((String)((Object)serviceContext.getAttribute("pingOldTrackbacks"))));
            this.pingGoogle(entry, serviceContext);
            this.pingPingback(entry, serviceContext);
            this.pingTrackbacks(entry, trackbacks, pingOldTrackbacks, serviceContext);
        } else if (status != 0) {
            this.assetEntryLocalService.updateVisible(BlogsEntry.class.getName(), entryId, false);
            indexer.delete((Object)entry);
        }
        return entry;
    }

    protected String getUniqueUrlTitle(long entryId, long groupId, String title) throws SystemException {
        BlogsEntry entry;
        String urlTitle;
        String newUrlTitle = urlTitle = BlogsUtil.getUrlTitle(entryId, title);
        int i = 1;
        while ((entry = this.blogsEntryPersistence.fetchByG_UT(groupId, newUrlTitle)) != null && entry.getEntryId() != entryId) {
            newUrlTitle = String.valueOf(urlTitle) + "-" + i;
            ++i;
        }
        return newUrlTitle;
    }

    protected void notifySubscribers(BlogsEntry entry, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!entry.isApproved()) {
            return;
        }
        String layoutFullURL = PortalUtil.getLayoutFullURL((long)serviceContext.getScopeGroupId(), (String)"33");
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = entry.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "33";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(entry.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(serviceContext.isCommandAdd() && BlogsUtil.getEmailEntryAddedEnabled(preferences) || serviceContext.isCommandUpdate() && BlogsUtil.getEmailEntryUpdatedEnabled(preferences))) {
            return;
        }
        Company company = this.companyPersistence.findByPrimaryKey(entry.getCompanyId());
        Group group = this.groupPersistence.findByPrimaryKey(serviceContext.getScopeGroupId());
        String emailAddress = "";
        String fullName = entry.getUserName();
        try {
            User user = this.userPersistence.findByPrimaryKey(entry.getUserId());
            emailAddress = user.getEmailAddress();
            fullName = user.getFullName();
        }
        catch (NoSuchUserException noSuchUserException) {}
        String portletName = PortalUtil.getPortletTitle((String)"33", (Locale)LocaleUtil.getDefault());
        String fromName = BlogsUtil.getEmailFromName(preferences);
        String fromAddress = BlogsUtil.getEmailFromAddress(preferences);
        fromName = StringUtil.replace((String)fromName, (String[])new String[]{"[$BLOGS_ENTRY_USER_ADDRESS$]", "[$BLOGS_ENTRY_USER_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{emailAddress, fullName, String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), portletName});
        fromAddress = StringUtil.replace((String)fromAddress, (String[])new String[]{"[$BLOGS_ENTRY_USER_ADDRESS$]", "[$BLOGS_ENTRY_USER_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{emailAddress, fullName, String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), portletName});
        String entryURL = String.valueOf(layoutFullURL) + "/-/" + "blogs" + "/" + entry.getEntryId();
        String subject = null;
        String body = null;
        if (serviceContext.isCommandUpdate()) {
            subject = BlogsUtil.getEmailEntryUpdatedSubject(preferences);
            body = BlogsUtil.getEmailEntryUpdatedBody(preferences);
        } else {
            subject = BlogsUtil.getEmailEntryAddedSubject(preferences);
            body = BlogsUtil.getEmailEntryAddedBody(preferences);
        }
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$BLOGS_ENTRY_USER_ADDRESS$]", "[$BLOGS_ENTRY_USER_NAME$]", "[$BLOGS_ENTRY_URL$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{emailAddress, fullName, entryURL, String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), fromAddress, fromName, company.getVirtualHost(), portletName});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$BLOGS_ENTRY_USER_ADDRESS$]", "[$BLOGS_ENTRY_USER_NAME$]", "[$BLOGS_ENTRY_URL$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{emailAddress, fullName, entryURL, String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), fromAddress, fromName, company.getVirtualHost(), portletName});
        Message message = new Message();
        message.put("companyId", (Object)entry.getCompanyId());
        message.put("userId", (Object)entry.getUserId());
        message.put("groupId", (Object)entry.getGroupId());
        message.put("entryId", (Object)entry.getEntryId());
        message.put("fromName", (Object)fromName);
        message.put("fromAddress", (Object)fromAddress);
        message.put("subject", (Object)subject);
        message.put("body", (Object)body);
        message.put("replyToAddress", (Object)fromAddress);
        message.put("mailId", (Object)BlogsUtil.getMailId(company.getMx(), entry.getEntryId()));
        message.put("htmlFormat", (Object)Boolean.TRUE);
        MessageBusUtil.sendMessage((String)"liferay/blogs", (Message)message);
    }

    protected void pingGoogle(BlogsEntry entry, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!PropsValues.BLOGS_PING_GOOGLE_ENABLED || !entry.isApproved()) {
            return;
        }
        String layoutFullURL = PortalUtil.getLayoutFullURL((long)serviceContext.getScopeGroupId(), (String)"33");
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        if (layoutFullURL.contains("://localhost")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not pinging Google because of localhost URL " + layoutFullURL));
            }
            return;
        }
        Group group = this.groupPersistence.findByPrimaryKey(entry.getGroupId());
        StringBundler sb = new StringBundler(6);
        String name = group.getDescriptiveName();
        String url = String.valueOf(layoutFullURL) + "/-/" + "blogs";
        String changesURL = String.valueOf(layoutFullURL) + "/-/" + "blogs/rss";
        sb.append("http://blogsearch.google.com/ping?name=");
        sb.append(HttpUtil.encodeURL((String)name));
        sb.append("&url=");
        sb.append(HttpUtil.encodeURL((String)url));
        sb.append("&changesURL=");
        sb.append(HttpUtil.encodeURL((String)changesURL));
        String location = sb.toString();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Pinging Google at " + location));
        }
        try {
            String response = HttpUtil.URLtoString((String)sb.toString());
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Google ping response: " + response));
            }
        }
        catch (IOException ioe) {
            _log.error((Object)("Unable to ping Google at " + location), (Throwable)ioe);
        }
    }

    protected void pingPingback(BlogsEntry entry, ServiceContext serviceContext) {
        if (!(PropsValues.BLOGS_PINGBACK_ENABLED && entry.isAllowPingbacks() && entry.isApproved())) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        String sourceUri = String.valueOf(layoutFullURL) + "/-/" + "blogs/" + entry.getUrlTitle();
        Source source = new Source((CharSequence)entry.getContent());
        List tags = source.getAllStartTags("a");
        for (StartTag tag : tags) {
            String targetUri = tag.getAttributeValue("href");
            if (!Validator.isNotNull((String)targetUri)) continue;
            try {
                LinkbackProducerUtil.sendPingback(sourceUri, targetUri);
            }
            catch (Exception e) {
                _log.error((Object)("Error while sending pingback " + targetUri), (Throwable)e);
            }
        }
    }

    protected void pingTrackbacks(BlogsEntry entry, String[] trackbacks, boolean pingOldTrackbacks, ServiceContext serviceContext) throws SystemException {
        if (!(PropsValues.BLOGS_TRACKBACK_ENABLED && entry.isAllowTrackbacks() && entry.isApproved())) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        HashMap<String, String> parts = new HashMap<String, String>();
        String excerpt = StringUtil.shorten((String)HtmlUtil.extractText((String)entry.getContent()), (int)PropsValues.BLOGS_LINKBACK_EXCERPT_LENGTH);
        String url = String.valueOf(layoutFullURL) + "/-/" + "blogs/" + entry.getUrlTitle();
        parts.put("title", entry.getTitle());
        parts.put("excerpt", excerpt);
        parts.put("url", url);
        parts.put("blog_name", entry.getUserName());
        HashSet trackbacksSet = null;
        trackbacksSet = Validator.isNotNull((Object[])trackbacks) ? SetUtil.fromArray((Object[])trackbacks) : new HashSet();
        if (pingOldTrackbacks) {
            trackbacksSet.addAll(SetUtil.fromArray((Object[])StringUtil.split((String)entry.getTrackbacks())));
            entry.setTrackbacks("");
            this.blogsEntryPersistence.update((BaseModel)entry, false);
        }
        Set oldTrackbacks = SetUtil.fromArray((Object[])StringUtil.split((String)entry.getTrackbacks()));
        HashSet<String> validTrackbacks = new HashSet<String>();
        for (String trackback : trackbacksSet) {
            if (oldTrackbacks.contains(trackback)) continue;
            try {
                if (!LinkbackProducerUtil.sendTrackback(trackback, parts)) continue;
                validTrackbacks.add(trackback);
            }
            catch (Exception e) {
                _log.error((Object)("Error while sending trackback at " + trackback), (Throwable)e);
            }
        }
        if (!validTrackbacks.isEmpty()) {
            String newTrackbacks = StringUtil.merge(validTrackbacks);
            if (Validator.isNotNull((String)entry.getTrackbacks())) {
                newTrackbacks = String.valueOf(newTrackbacks) + "," + entry.getTrackbacks();
            }
            entry.setTrackbacks(newTrackbacks);
            this.blogsEntryPersistence.update((BaseModel)entry, false);
        }
    }

    protected void validate(String title, String content) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new EntryTitleException();
        }
        if (Validator.isNull((String)content)) {
            throw new EntryContentException();
        }
    }
}

