/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryServiceUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(BlogsEntryServiceHttp.class);

    public static BlogsEntry addEntry(HttpPrincipal httpPrincipal, String title, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "addEntry", new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String[].class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{title, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (BlogsEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "deleteEntry", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BlogsEntry> getCompanyEntries(HttpPrincipal httpPrincipal, long companyId, int status, int max) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "getCompanyEntries", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, status, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String getCompanyEntriesRSS(HttpPrincipal httpPrincipal, long companyId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "getCompanyEntriesRSS", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, String.class, Double.TYPE, String.class, String.class, String.class, ThemeDisplay.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BlogsEntry getEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "getEntry", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (BlogsEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BlogsEntry getEntry(HttpPrincipal httpPrincipal, long groupId, String urlTitle) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "getEntry", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, urlTitle});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (BlogsEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BlogsEntry> getGroupEntries(HttpPrincipal httpPrincipal, long groupId, int status, int max) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "getGroupEntries", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, status, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String getGroupEntriesRSS(HttpPrincipal httpPrincipal, long groupId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "getGroupEntriesRSS", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, String.class, Double.TYPE, String.class, String.class, String.class, ThemeDisplay.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BlogsEntry> getGroupsEntries(HttpPrincipal httpPrincipal, long companyId, long groupId, int status, int max) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "getGroupsEntries", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, groupId, status, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<BlogsEntry> getOrganizationEntries(HttpPrincipal httpPrincipal, long organizationId, int status, int max) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "getOrganizationEntries", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizationId, status, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String getOrganizationEntriesRSS(HttpPrincipal httpPrincipal, long organizationId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "getOrganizationEntriesRSS", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, String.class, Double.TYPE, String.class, String.class, String.class, ThemeDisplay.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizationId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static BlogsEntry updateEntry(HttpPrincipal httpPrincipal, long entryId, String title, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(BlogsEntryServiceUtil.class.getName(), "updateEntry", new Class[]{Long.TYPE, String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String[].class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId, title, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (BlogsEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

