/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import java.util.List;

public class VerifyMessageBoards
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyMessageBoards.class);

    protected void doVerify() throws Exception {
        int messageCount;
        List categories = MBCategoryLocalServiceUtil.getMBCategories((int)-1, (int)-1);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + categories.size() + " categories for statistics accuracy"));
        }
        for (MBCategory category : categories) {
            int threadCount = MBThreadLocalServiceUtil.getCategoryThreadsCount((long)category.getGroupId(), (long)category.getCategoryId(), (int)0);
            messageCount = MBMessageLocalServiceUtil.getCategoryMessagesCount((long)category.getGroupId(), (long)category.getCategoryId(), (int)0);
            if (category.getThreadCount() == threadCount && category.getMessageCount() == messageCount) continue;
            category.setThreadCount(threadCount);
            category.setMessageCount(messageCount);
            MBCategoryLocalServiceUtil.updateMBCategory((MBCategory)category);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Statistics verified for categories");
        }
        List threads = MBThreadLocalServiceUtil.getMBThreads((int)-1, (int)-1);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + threads.size() + " threads for statistics accuracy"));
        }
        for (MBThread thread : threads) {
            messageCount = MBMessageLocalServiceUtil.getThreadMessagesCount((long)thread.getThreadId(), (int)0);
            if (thread.getMessageCount() == messageCount) continue;
            thread.setMessageCount(messageCount);
            MBThreadLocalServiceUtil.updateMBThread((MBThread)thread);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Statistics verified for threads");
        }
        List messages = MBMessageLocalServiceUtil.getNoAssetMessages();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + messages.size() + " messages with no asset"));
        }
        for (MBMessage message : messages) {
            try {
                MBMessageLocalServiceUtil.updateAsset((long)message.getUserId(), (MBMessage)message, null, null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for message " + message.getMessageId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for messages");
        }
    }
}

