/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.text.Format;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.time.FastDateFormat;

public class FastDateFormatFactoryImpl
implements FastDateFormatFactory {
    private Map<String, Format> _dateFormats = new ConcurrentHashMap<String, Format>();
    private Map<String, Format> _dateTimeFormats = new ConcurrentHashMap<String, Format>();
    private Map<String, Format> _simpleDateFormats = new ConcurrentHashMap<String, Format>();
    private Map<String, Format> _timeFormats = new ConcurrentHashMap<String, Format>();

    public Format getDate(Locale locale) {
        return this.getDate(locale, null);
    }

    public Format getDate(Locale locale, TimeZone timeZone) {
        String key = this.getKey(locale, timeZone);
        Format format = this._dateFormats.get(key);
        if (format == null) {
            format = FastDateFormat.getDateInstance((int)3, (TimeZone)timeZone, (Locale)locale);
            this._dateFormats.put(key, format);
        }
        return format;
    }

    public Format getDate(TimeZone timeZone) {
        return this.getDate(LocaleUtil.getDefault(), timeZone);
    }

    public Format getDateTime(Locale locale) {
        return this.getDateTime(locale, null);
    }

    public Format getDateTime(Locale locale, TimeZone timeZone) {
        String key = this.getKey(locale, timeZone);
        Format format = this._dateTimeFormats.get(key);
        if (format == null) {
            format = FastDateFormat.getDateTimeInstance((int)3, (int)3, (TimeZone)timeZone, (Locale)locale);
            this._dateTimeFormats.put(key, format);
        }
        return format;
    }

    public Format getDateTime(TimeZone timeZone) {
        return this.getDateTime(LocaleUtil.getDefault(), timeZone);
    }

    public Format getSimpleDateFormat(String pattern) {
        return this.getSimpleDateFormat(pattern, LocaleUtil.getDefault(), null);
    }

    public Format getSimpleDateFormat(String pattern, Locale locale) {
        return this.getSimpleDateFormat(pattern, locale, null);
    }

    public Format getSimpleDateFormat(String pattern, Locale locale, TimeZone timeZone) {
        String key = this.getKey(pattern, locale, timeZone);
        Format format = this._simpleDateFormats.get(key);
        if (format == null) {
            format = FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone, (Locale)locale);
            this._simpleDateFormats.put(key, format);
        }
        return format;
    }

    public Format getSimpleDateFormat(String pattern, TimeZone timeZone) {
        return this.getSimpleDateFormat(pattern, LocaleUtil.getDefault(), timeZone);
    }

    public Format getTime(Locale locale) {
        return this.getTime(locale, null);
    }

    public Format getTime(Locale locale, TimeZone timeZone) {
        String key = this.getKey(locale, timeZone);
        Format format = this._timeFormats.get(key);
        if (format == null) {
            format = FastDateFormat.getTimeInstance((int)3, (TimeZone)timeZone, (Locale)locale);
            this._timeFormats.put(key, format);
        }
        return format;
    }

    public Format getTime(TimeZone timeZone) {
        return this.getTime(LocaleUtil.getDefault(), timeZone);
    }

    protected String getKey(Locale locale, TimeZone timeZone) {
        return String.valueOf(locale).concat("_").concat(String.valueOf(timeZone));
    }

    protected String getKey(String pattern, Locale locale, TimeZone timeZone) {
        StringBundler sb = new StringBundler(5);
        sb.append(pattern);
        sb.append("_");
        sb.append(String.valueOf(locale));
        sb.append("_");
        sb.append(String.valueOf(timeZone));
        return sb.toString();
    }
}

