/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.CookieNotSupportedException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.CookieUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Hex;

public class CookieKeys {
    public static final String COOKIE_SUPPORT = "COOKIE_SUPPORT";
    public static final String COMPANY_ID = "COMPANY_ID";
    public static final String GUEST_LANGUAGE_ID = "GUEST_LANGUAGE_ID";
    public static final String ID = "ID";
    public static final String JSESSIONID = "jsessionid";
    public static final String LOGIN = "LOGIN";
    public static final String PASSWORD = "PASSWORD";
    public static final String REMEMBER_ME = "REMEMBER_ME";
    public static final String SCREEN_NAME = "SCREEN_NAME";
    public static final int MAX_AGE = 31536000;
    public static final int VERSION = 0;
    private static Log _log = LogFactoryUtil.getLog(CookieKeys.class);

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, Cookie cookie) {
        CookieKeys.addCookie(request, response, cookie, request.isSecure());
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, Cookie cookie, boolean secure) {
        String originalValue;
        if (!PropsValues.SESSION_ENABLE_PERSISTENT_COOKIES || PropsValues.TCK_URL) {
            return;
        }
        String name = cookie.getName();
        String encodedValue = originalValue = cookie.getValue();
        if (CookieKeys.isEncodedCookie(name)) {
            encodedValue = new String(Hex.encodeHex((byte[])originalValue.getBytes()));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Add encoded cookie " + name));
                _log.debug((Object)("Original value " + originalValue));
                _log.debug((Object)("Hex encoded value " + encodedValue));
            }
        }
        cookie.setSecure(secure);
        cookie.setValue(encodedValue);
        cookie.setVersion(0);
        response.addCookie(cookie);
    }

    public static void addSupportCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookieSupportCookie = new Cookie(COOKIE_SUPPORT, "true");
        cookieSupportCookie.setPath("/");
        cookieSupportCookie.setMaxAge(31536000);
        CookieKeys.addCookie(request, response, cookieSupportCookie);
    }

    public static String getCookie(HttpServletRequest request, String name) {
        String value = CookieUtil.get((HttpServletRequest)request, (String)name);
        if (value != null && CookieKeys.isEncodedCookie(name)) {
            try {
                String encodedValue = value;
                String originalValue = new String(Hex.decodeHex((char[])encodedValue.toCharArray()));
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Get encoded cookie " + name));
                    _log.debug((Object)("Hex encoded value " + encodedValue));
                    _log.debug((Object)("Original value " + originalValue));
                }
                return originalValue;
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e.getMessage());
                }
                return value;
            }
        }
        return value;
    }

    public static String getDomain(HttpServletRequest request) {
        if (Validator.isNotNull((String)PropsValues.SESSION_COOKIE_DOMAIN)) {
            return PropsValues.SESSION_COOKIE_DOMAIN;
        }
        String host = request.getServerName();
        return CookieKeys.getDomain(host);
    }

    public static String getDomain(String host) {
        if (host == null) {
            return null;
        }
        if (Validator.isIPAddress((String)host)) {
            return host;
        }
        int x = host.lastIndexOf(46);
        if (x <= 0) {
            return null;
        }
        int y = host.lastIndexOf(46, x - 1);
        if (y <= 0) {
            return "." + host;
        }
        int z = host.lastIndexOf(46, y - 1);
        String domain = null;
        domain = z <= 0 ? host.substring(y) : host.substring(z);
        return domain;
    }

    public static boolean hasSessionId(HttpServletRequest request) {
        String jsessionid = CookieKeys.getCookie(request, JSESSIONID);
        return jsessionid != null;
    }

    public static boolean isEncodedCookie(String name) {
        return name.equals(ID) || name.equals(LOGIN) || name.equals(PASSWORD) || name.equals(SCREEN_NAME);
    }

    public static void validateSupportCookie(HttpServletRequest request) throws CookieNotSupportedException {
        String cookieSupport;
        if (PropsValues.SESSION_ENABLE_PERSISTENT_COOKIES && PropsValues.SESSION_TEST_COOKIE_SUPPORT && Validator.isNull((String)(cookieSupport = CookieKeys.getCookie(request, COOKIE_SUPPORT)))) {
            throw new CookieNotSupportedException();
        }
    }
}

