/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStreamWrapper;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.upload.LiferayFileUpload;
import com.liferay.portal.util.PropsUtil;
import com.liferay.util.servlet.ServletInputStreamWrapper;
import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LiferayInputStream
extends ServletInputStreamWrapper {
    public static final int THRESHOLD_SIZE = GetterUtil.getInteger((String)PropsUtil.get(String.valueOf(LiferayInputStream.class.getName()) + ".threshold.size"));
    private static Log _log = LogFactoryUtil.getLog(LiferayInputStream.class);
    private HttpSession _session;
    private int _totalRead;
    private int _totalSize;
    private UnsyncByteArrayOutputStream _cachedBytes = new UnsyncByteArrayOutputStream();

    public LiferayInputStream(HttpServletRequest request) throws IOException {
        super(request.getInputStream());
        this._session = request.getSession();
        this._totalSize = request.getContentLength();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        Integer curPercent;
        int bytesRead = super.read(b, off, len);
        if (bytesRead > 0) {
            this._totalRead += bytesRead;
        } else {
            return bytesRead;
        }
        int percent = this._totalRead * 100 / this._totalSize;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(String.valueOf(bytesRead) + "/" + this._totalRead + "=" + percent));
        }
        if (this._totalSize < THRESHOLD_SIZE) {
            this._cachedBytes.write(b, off, bytesRead);
        }
        if ((curPercent = (Integer)this._session.getAttribute(LiferayFileUpload.PERCENT)) == null || percent - curPercent >= 1) {
            this._session.setAttribute(LiferayFileUpload.PERCENT, (Object)new Integer(percent));
        }
        return bytesRead;
    }

    public ServletInputStream getCachedInputStream() {
        if (this._totalSize < THRESHOLD_SIZE) {
            return this;
        }
        return new UnsyncByteArrayInputStreamWrapper(new UnsyncByteArrayInputStream(this._cachedBytes.unsafeGetByteArray(), 0, this._cachedBytes.size()));
    }
}

