/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_3;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FileUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateFileEntries();
        this.updateFileVersions();
    }

    protected long getLatestFileVersionId(long folderId, String name) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        long fileVersionId = 0L;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select fileVersionId from DLFileVersion where folderId = ? and name = ? order by version desc");
            ps.setLong(1, folderId);
            ps.setString(2, name);
            rs = ps.executeQuery();
            if (rs.next()) {
                fileVersionId = rs.getLong("fileVersionId");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return fileVersionId;
    }

    protected void updateFileEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select uuid_, fileEntryId, groupId, folderId, name, title from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                String uuid_ = rs.getString("uuid_");
                long fileEntryId = rs.getLong("fileEntryId");
                long groupId = rs.getLong("groupId");
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                String title = rs.getString("title");
                String extension = FileUtil.getExtension((String)title);
                this.runSQL("update DLFileEntry set extension = '" + extension + "' where uuid_ = '" + uuid_ + "' and groupId = " + groupId);
                long fileVersionId = this.getLatestFileVersionId(folderId, name);
                this.runSQL("update ExpandoRow set classPK = " + fileVersionId + " where classPK = " + fileEntryId);
                this.runSQL("update ExpandoValue set classPK = " + fileVersionId + " where classPK = " + fileEntryId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateFileVersion(long fileVersionId, String extension, String title, String description, String extraSettings) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update DLFileVersion set extension = ?, title = ?, description = ?,  extraSettings = ? where fileVersionId = ?");
            ps.setString(1, extension);
            ps.setString(2, title);
            ps.setString(3, description);
            ps.setString(4, extraSettings);
            ps.setLong(5, fileVersionId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateFileVersions() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select folderId, name, extension, title, description, extraSettings from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                long folderId = rs.getLong("folderId");
                String name = rs.getString("name");
                String extension = rs.getString("extension");
                String title = rs.getString("title");
                String description = rs.getString("description");
                String extraSettings = rs.getString("extraSettings");
                long fileVersionId = this.getLatestFileVersionId(folderId, name);
                this.updateFileVersion(fileVersionId, extension, title, description, extraSettings);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

