/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_3;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesSerializer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeAssetPublisher
extends BaseUpgradePortletPreferences {
    protected String[] getAssetEntryXmls(String[] assetEntryXmls) throws Exception {
        String[] newAssetEntryXmls = new String[assetEntryXmls.length];
        int i = 0;
        while (i < assetEntryXmls.length) {
            String assetEntryXml = assetEntryXmls[i];
            Document document = SAXReaderUtil.read((String)assetEntryXml);
            Element rootElement = document.getRootElement();
            Element assetEntryIdElement = rootElement.element("asset-entry-id");
            long assetEntryId = GetterUtil.getLong((String)assetEntryIdElement.getText());
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                con = DataAccess.getConnection();
                ps = con.prepareStatement("select classUuid from AssetEntry where entryId = ?");
                ps.setLong(1, assetEntryId);
                rs = ps.executeQuery();
                rs.next();
                String classUuid = rs.getString("classUuid");
                Element assetEntryUuidElement = rootElement.addElement("asset-entry-uuid");
                assetEntryUuidElement.addText(classUuid);
                rootElement.remove(assetEntryIdElement);
                newAssetEntryXmls[i] = document.formattedString("");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            ++i;
        }
        return newAssetEntryXmls;
    }

    protected String getUpdatePortletPreferencesWhereClause() {
        return "portletId like '101_INSTANCE_%'";
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferencesImpl preferences = PortletPreferencesSerializer.fromXML(companyId, ownerId, ownerType, plid, portletId, xml);
        String selectionStyle = preferences.getValue("selection-style", null);
        if (Validator.isNotNull((String)selectionStyle) && !selectionStyle.equals("dynamic")) {
            String[] assetEntryXmls = preferences.getValues("asset-entry-xml", new String[0]);
            String[] newAssetEntryXmls = this.getAssetEntryXmls(assetEntryXmls);
            preferences.setValues("asset-entry-xml", newAssetEntryXmls);
        }
        return PortletPreferencesSerializer.toXML(preferences);
    }
}

