/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v4_4_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeLayout
extends UpgradeProcess {
    private static final String _GET_LAYOUT = "select * from Layout where plid = ?";

    protected void doUpgrade() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select plid, typeSettings from Layout where type_ = 'link_to_layout'");
            rs = ps.executeQuery();
            while (rs.next()) {
                Object[] layout;
                long plid = rs.getLong("plid");
                String typeSettings = rs.getString("typeSettings");
                UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
                typeSettingsProperties.load(typeSettings);
                long linkToPlid = GetterUtil.getLong((String)typeSettingsProperties.getProperty("linkToPlid"));
                if (linkToPlid > 0L && (layout = this.getLayout(linkToPlid)) != null) {
                    long groupId = (Long)layout[0];
                    boolean privateLayout = (Boolean)layout[1];
                    long layoutId = (Long)layout[2];
                    typeSettingsProperties.remove((Object)"linkToPlid");
                    typeSettingsProperties.put("groupId", String.valueOf(groupId));
                    typeSettingsProperties.put("privateLayout", String.valueOf(privateLayout));
                    typeSettingsProperties.put("linkToLayoutId", String.valueOf(layoutId));
                }
                this.updateTypeSettings(plid, typeSettingsProperties.toString());
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected Object[] getLayout(long plid) throws Exception {
        Object[] layout = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_LAYOUT);
            ps.setLong(1, plid);
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                boolean privateLayout = rs.getBoolean("privateLayout");
                long layoutId = rs.getLong("layoutId");
                layout = new Object[]{groupId, privateLayout, layoutId};
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return layout;
    }

    protected void updateTypeSettings(long plid, String typeSettings) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);
            ps.setString(1, typeSettings);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

