/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.dao.orm.hibernate.DB2Dialect;
import com.liferay.portal.dao.orm.hibernate.SQLServer2008Dialect;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.dialect.DB2400Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.dialect.resolver.DialectFactory;

public class DialectDetector {
    private static Log _log = LogFactoryUtil.getLog(DialectDetector.class);

    public static String determineDialect(DataSource dataSource) {
        Dialect dialect = DialectDetector.getDialect(dataSource);
        DBFactoryUtil.setDB((Object)dialect);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Using dialect " + dialect.getClass().getName()));
        }
        return dialect.getClass().getName();
    }

    public static Dialect getDialect(DataSource dataSource) {
        Object dialect;
        block11: {
            dialect = null;
            Connection connection = null;
            try {
                try {
                    connection = dataSource.getConnection();
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String dbName = databaseMetaData.getDatabaseProductName();
                    int dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Determining dialect for " + dbName + " " + dbMajorVersion));
                    }
                    if (dbName.startsWith("HSQL") && _log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler(6);
                        sb.append("Liferay is configured to use Hypersonic as ");
                        sb.append("its database. Do NOT use Hypersonic in ");
                        sb.append("production. Hypersonic is an embedded ");
                        sb.append("database useful for development and demo'ing ");
                        sb.append("purposes. The database settings can be ");
                        sb.append("changed in portal.properties.");
                        _log.warn((Object)sb.toString());
                    }
                    dialect = dbName.equals("ASE") && dbMajorVersion == 15 ? new SybaseASE15Dialect() : (dbName.startsWith("DB2") && dbMajorVersion == 9 ? new DB2Dialect() : (dbName.startsWith("Microsoft") && dbMajorVersion >= 9 ? new SQLServer2008Dialect() : DialectFactory.buildDialect((Properties)new Properties(), (Connection)connection)));
                }
                catch (Exception e) {
                    String msg = GetterUtil.getString((String)e.getMessage());
                    if (msg.indexOf("explicitly set for database: DB2") != -1) {
                        dialect = new DB2400Dialect();
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)"DB2400Dialect was dynamically chosen as the Hibernate dialect for DB2. This can be overriden in portal.properties");
                        }
                    } else {
                        _log.error((Object)e, (Throwable)e);
                    }
                    DataAccess.cleanUp((Connection)connection);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)connection);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)connection);
        }
        if (dialect == null) {
            throw new RuntimeException("No dialect found");
        }
        return dialect;
    }
}

