/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.validhtml;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.util.servlet.ServletResponseUtil;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ValidHtmlFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = String.valueOf(ValidHtmlFilter.class.getName()) + "SKIP_FILTER";
    private static final String _CLOSE_BODY = "</body>";
    private static final String _CLOSE_HTML = "</html>";
    private static Log _log = LogFactoryUtil.getLog(ValidHtmlFilter.class);

    protected String getContent(HttpServletRequest request, String content) {
        content = StringUtil.replaceLast((String)content, (String)_CLOSE_BODY, (String)"");
        content = StringUtil.replaceLast((String)content, (String)_CLOSE_HTML, (String)"</body></html>");
        return content;
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isEnsureValidHtml(HttpServletRequest request, HttpServletResponse response) {
        String contentType = response.getContentType();
        return contentType != null && contentType.startsWith("text/html");
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        if (this.isEnsureValidHtml(request, response) && !this.isAlreadyFiltered(request)) {
            request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Ensuring valid HTML " + completeURL));
            }
            StringServletResponse stringServerResponse = new StringServletResponse(response);
            this.processFilter(ValidHtmlFilter.class, request, (HttpServletResponse)stringServerResponse, filterChain);
            String content = this.getContent(request, stringServerResponse.getString());
            ServletResponseUtil.write((HttpServletResponse)response, (String)content);
        } else {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Not ensuring valid HTML " + completeURL));
            }
            this.processFilter(ValidHtmlFilter.class, request, response, filterChain);
        }
    }
}

