/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.servlet.UncommittedServletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.util.servlet.ServletResponseUtil;
import com.liferay.util.xml.XMLFormatter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AxisServlet
extends org.apache.axis.transport.http.AxisServlet {
    private static final String _CORRECT_LONG_ARRAY = "<complexType name=\"ArrayOf_xsd_long\"><complexContent><restriction base=\"soapenc:Array\"><attribute ref=\"soapenc:arrayType\" wsdl:arrayType=\"soapenc:long[]\"/></restriction></complexContent></complexType>";
    private static final String _CORRECT_STRING_ARRAY = "<complexType name=\"ArrayOf_xsd_string\"><complexContent><restriction base=\"soapenc:Array\"><attribute ref=\"soapenc:arrayType\" wsdl:arrayType=\"soapenc:string[]\"/></restriction></complexContent></complexType>";
    private static final String _HTML_BOTTOM_WRAPPER = "</body></html>";
    private static final String _HTML_TOP_WRAPPER = "<html><body>";
    private static final String _INCORRECT_LONG_ARRAY = "<complexType name=\"ArrayOf_xsd_long\"><simpleContent><extension/></simpleContent></complexType>";
    private static final String _INCORRECT_STRING_ARRAY = "<complexType name=\"ArrayOf_xsd_string\"><simpleContent><extension/></simpleContent></complexType>";
    private static Log _log = LogFactoryUtil.getLog(AxisServlet.class);
    private ClassLoader _portletClassLoader;

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        this._portletClassLoader = (ClassLoader)servletContext.getAttribute("PORTLET_CLASS_LOADER");
        if (this._portletClassLoader == null) {
            super.init(servletConfig);
        } else {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this._portletClassLoader);
                super.init(servletConfig);
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        try {
            PortalInstances.getCompanyId(request);
            String remoteUser = request.getRemoteUser();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Remote user " + remoteUser));
            }
            if (remoteUser != null) {
                PrincipalThreadLocal.setName((String)remoteUser);
                long userId = GetterUtil.getLong((String)remoteUser);
                User user = UserLocalServiceUtil.getUserById((long)userId);
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)true);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            }
            StringServletResponse stringResponse = new StringServletResponse(response);
            if (this._portletClassLoader == null) {
                super.service(request, (HttpServletResponse)stringResponse);
            } else {
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(this._portletClassLoader);
                    super.service(request, (HttpServletResponse)stringResponse);
                }
                finally {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
            }
            String contentType = stringResponse.getContentType();
            response.setContentType(contentType);
            String content = stringResponse.getString();
            if (contentType.contains("text/html")) {
                content = _HTML_TOP_WRAPPER.concat(content).concat(_HTML_BOTTOM_WRAPPER);
            } else if (contentType.contains("text/xml")) {
                content = this.fixXml(content);
            }
            ServletResponseUtil.write((HttpServletResponse)new UncommittedServletResponse(response), (byte[])content.getBytes("UTF-8"));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected String fixXml(String xml) throws Exception {
        if (xml.indexOf("<wsdl:definitions") == -1) {
            return xml;
        }
        xml = StringUtil.replace((String)xml, (String[])new String[]{"\r\n", "\n", "  ", "> <", _INCORRECT_LONG_ARRAY, _INCORRECT_STRING_ARRAY}, (String[])new String[]{"", "", "", "><", _CORRECT_LONG_ARRAY, _CORRECT_STRING_ARRAY});
        xml = XMLFormatter.toString((String)xml);
        return xml;
    }
}

