/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.service.persistence.GroupFinder;
import com.liferay.portal.service.persistence.GroupUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupFinderImpl
extends BasePersistenceImpl<Group>
implements GroupFinder {
    public static String COUNT_BY_GROUP_ID = String.valueOf(GroupFinder.class.getName()) + ".countByGroupId";
    public static String COUNT_BY_C_N_D = String.valueOf(GroupFinder.class.getName()) + ".countByC_N_D";
    public static String FIND_BY_LIVE_GROUPS = String.valueOf(GroupFinder.class.getName()) + ".findByLiveGroups";
    public static String FIND_BY_NO_LAYOUTS = String.valueOf(GroupFinder.class.getName()) + ".findByNoLayouts";
    public static String FIND_BY_NULL_FRIENDLY_URL = String.valueOf(GroupFinder.class.getName()) + ".findByNullFriendlyURL";
    public static String FIND_BY_SYSTEM = String.valueOf(GroupFinder.class.getName()) + ".findBySystem";
    public static String FIND_BY_C_N = String.valueOf(GroupFinder.class.getName()) + ".findByC_N";
    public static String FIND_BY_C_N_D = String.valueOf(GroupFinder.class.getName()) + ".findByC_N_D";
    public static String JOIN_BY_ACTIVE = String.valueOf(GroupFinder.class.getName()) + ".joinByActive";
    public static String JOIN_BY_CREATOR_USER_ID = String.valueOf(GroupFinder.class.getName()) + ".joinByCreatorUserId";
    public static String JOIN_BY_GROUPS_ORGS = String.valueOf(GroupFinder.class.getName()) + ".joinByGroupsOrgs";
    public static String JOIN_BY_GROUPS_ROLES = String.valueOf(GroupFinder.class.getName()) + ".joinByGroupsRoles";
    public static String JOIN_BY_GROUPS_USER_GROUPS = String.valueOf(GroupFinder.class.getName()) + ".joinByGroupsUserGroups";
    public static String JOIN_BY_LAYOUT_SET = String.valueOf(GroupFinder.class.getName()) + ".joinByLayoutSet";
    public static String JOIN_BY_PAGE_COUNT = String.valueOf(GroupFinder.class.getName()) + ".joinByPageCount";
    public static String JOIN_BY_ROLE_PERMISSIONS = String.valueOf(GroupFinder.class.getName()) + ".joinByRolePermissions";
    public static String JOIN_BY_ROLE_RESOURCE_PERMISSIONS = String.valueOf(GroupFinder.class.getName()) + ".joinByRoleResourcePermissions";
    public static String JOIN_BY_TYPE = String.valueOf(GroupFinder.class.getName()) + ".joinByType";
    public static String JOIN_BY_USER_GROUP_ROLE = String.valueOf(GroupFinder.class.getName()) + ".joinByUserGroupRole";
    public static String JOIN_BY_USERS_GROUPS = String.valueOf(GroupFinder.class.getName()) + ".joinByUsersGroups";

    public int countByG_U(long groupId, long userId) throws SystemException {
        LinkedHashMap<String, Object> params1 = new LinkedHashMap<String, Object>();
        params1.put("usersGroups", userId);
        LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
        params2.put("groupsOrgs", userId);
        LinkedHashMap<String, Object> params3 = new LinkedHashMap<String, Object>();
        params3.put("groupsUserGroups", userId);
        Session session = null;
        try {
            session = this.openSession();
            int count = this.countByGroupId(session, groupId, params1);
            count += this.countByGroupId(session, groupId, params2);
            int n = count += this.countByGroupId(session, groupId, params3);
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_N_D(long companyId, String name, String realName, String description, LinkedHashMap<String, Object> params) throws SystemException {
        return this.countByC_C_N_D(companyId, new long[]{PortalUtil.getClassNameId(Group.class)}, name, realName, description, params);
    }

    public int countByC_C_N_D(long companyId, long[] classNameIds, String name, String realName, String description, LinkedHashMap<String, Object> params) throws SystemException {
        name = StringUtil.lowerCase((String)name);
        description = StringUtil.lowerCase((String)description);
        if (params == null) {
            params = new LinkedHashMap();
        }
        Long userId = (Long)params.get("usersGroups");
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
        params2.putAll(params1);
        if (userId != null) {
            params2.remove("usersGroups");
            params2.put("groupsOrgs", userId);
        }
        LinkedHashMap<String, Object> params3 = new LinkedHashMap<String, Object>();
        params3.putAll(params1);
        if (userId != null) {
            params3.remove("usersGroups");
            params3.put("groupsUserGroups", userId);
        }
        Session session = null;
        try {
            session = this.openSession();
            HashSet<Long> groupIds = new HashSet<Long>();
            groupIds.addAll(this.countByC_C_N_D(session, companyId, classNameIds, name, realName, description, params1));
            if (Validator.isNotNull((Long)userId)) {
                groupIds.addAll(this.countByC_C_N_D(session, companyId, classNameIds, name, realName, description, params2));
                groupIds.addAll(this.countByC_C_N_D(session, companyId, classNameIds, name, realName, description, params3));
            }
            int n = groupIds.size();
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByLiveGroups() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_LIVE_GROUPS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByNoLayouts(long classNameId, boolean privateLayout, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_SYSTEM);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(classNameId);
            qPos.add(privateLayout);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByNullFriendlyURL() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NULL_FRIENDLY_URL);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findBySystem(long companyId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_SYSTEM);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Group findByC_N(long companyId, String name) throws NoSuchGroupException, SystemException {
        name = StringUtil.lowerCase((String)name);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_N);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(name);
            List list = q.list();
            if (!list.isEmpty()) {
                Group group = (Group)list.get(0);
                return group;
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        StringBundler sb = new StringBundler(5);
        sb.append("No Group exists with the key {companyId=");
        sb.append(companyId);
        sb.append(", name=");
        sb.append(name);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public List<Group> findByC_N_D(long companyId, String name, String realName, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.findByC_C_N_D(companyId, new long[]{PortalUtil.getClassNameId(Group.class)}, name, realName, description, params, start, end, obc);
    }

    public List<Group> findByC_C_N_D(long companyId, long[] classNameIds, String name, String realName, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        name = StringUtil.lowerCase((String)name);
        description = StringUtil.lowerCase((String)description);
        if (params == null) {
            params = new LinkedHashMap();
        }
        Long userId = (Long)params.get("usersGroups");
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
        params2.putAll(params1);
        if (userId != null) {
            params2.remove("usersGroups");
            params2.put("groupsOrgs", userId);
        }
        LinkedHashMap<String, Object> params3 = new LinkedHashMap<String, Object>();
        params3.putAll(params1);
        if (userId != null) {
            params3.remove("usersGroups");
            params3.put("groupsUserGroups", userId);
        }
        StringBundler sb = new StringBundler();
        sb.append("(");
        sb.append(CustomSQLUtil.get((String)FIND_BY_C_N_D));
        String sql = sb.toString();
        sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params1));
        sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params1));
        sb.setIndex(0);
        sb.append(sql);
        sb.append(")");
        if (Validator.isNotNull((Long)userId)) {
            sb.append(" UNION (");
            sb.append(CustomSQLUtil.get((String)FIND_BY_C_N_D));
            sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params2));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params2));
            sb.setIndex(0);
            sb.append(sql);
            sb.append(") UNION (");
            sb.append(CustomSQLUtil.get((String)FIND_BY_C_N_D));
            sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params3));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params3));
            sb.setIndex(0);
            sb.append(sql);
            sb.append(")");
        }
        sql = sb.toString();
        sql = StringUtil.replace((String)sql, (String)"Group_.classNameId = ?", (String)"Group_.classNameId = ".concat(StringUtil.merge((long[])classNameIds, (String)" OR Group_.classNameId = ")));
        sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("groupId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params1);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(realName);
            qPos.add(name);
            qPos.add(description);
            qPos.add(description);
            if (Validator.isNotNull((Long)userId)) {
                this.setJoin(qPos, params2);
                qPos.add(companyId);
                qPos.add(name);
                qPos.add(realName);
                qPos.add(name);
                qPos.add(description);
                qPos.add(description);
                this.setJoin(qPos, params3);
                qPos.add(companyId);
                qPos.add(name);
                qPos.add(realName);
                qPos.add(name);
                qPos.add(description);
                qPos.add(description);
            }
            ArrayList<Group> groups = new ArrayList<Group>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                long groupId = (Long)itr.next();
                Group group = GroupUtil.findByPrimaryKey((long)groupId);
                groups.add(group);
            }
            ArrayList<Group> arrayList = groups;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int countByGroupId(Session session, long groupId, LinkedHashMap<String, Object> params) {
        Long count;
        String sql = CustomSQLUtil.get((String)COUNT_BY_GROUP_ID);
        sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
        sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
        SQLQuery q = session.createSQLQuery(sql);
        q.addScalar("COUNT_VALUE", Type.LONG);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        this.setJoin(qPos, params);
        qPos.add(groupId);
        Iterator itr = q.list().iterator();
        if (itr.hasNext() && (count = (Long)itr.next()) != null) {
            return count.intValue();
        }
        return 0;
    }

    protected List<Long> countByC_C_N_D(Session session, long companyId, long[] classNameIds, String name, String realName, String description, LinkedHashMap<String, Object> params) {
        String sql = CustomSQLUtil.get((String)COUNT_BY_C_N_D);
        sql = StringUtil.replace((String)sql, (String)"Group_.classNameId = ?", (String)"Group_.classNameId = ".concat(StringUtil.merge((long[])classNameIds, (String)" OR Group_.classNameId = ")));
        sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
        sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
        SQLQuery q = session.createSQLQuery(sql);
        q.addScalar("groupId", Type.LONG);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        this.setJoin(qPos, params);
        qPos.add(companyId);
        qPos.add(name);
        qPos.add(realName);
        qPos.add(name);
        qPos.add(description);
        qPos.add(description);
        return q.list();
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getJoin(key));
        }
        return sb.toString();
    }

    protected String getJoin(String key) {
        int pos;
        String join = "";
        if (key.equals("groupsOrgs")) {
            join = CustomSQLUtil.get((String)JOIN_BY_GROUPS_ORGS);
        } else if (key.equals("groupsRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_GROUPS_ROLES);
        } else if (key.equals("groupsUserGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_GROUPS_USER_GROUPS);
        } else if (key.equals("layoutSet")) {
            join = CustomSQLUtil.get((String)JOIN_BY_LAYOUT_SET);
        } else if (key.equals("pageCount")) {
            join = CustomSQLUtil.get((String)JOIN_BY_PAGE_COUNT);
        } else if (key.equals("rolePermissions")) {
            join = PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6 ? CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_PERMISSIONS) : CustomSQLUtil.get((String)JOIN_BY_ROLE_PERMISSIONS);
        } else if (key.equals("userGroupRole")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE);
        } else if (key.equals("usersGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS);
        }
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getWhere(key, value));
        }
        return sb.toString();
    }

    protected String getWhere(String key, Object value) {
        String join = "";
        if (key.equals("active")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ACTIVE);
        } else if (key.equals("creatorUserId")) {
            join = CustomSQLUtil.get((String)JOIN_BY_CREATOR_USER_ID);
        } else if (key.equals("groupsOrgs")) {
            join = CustomSQLUtil.get((String)JOIN_BY_GROUPS_ORGS);
        } else if (key.equals("groupsRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_GROUPS_ROLES);
        } else if (key.equals("groupsUserGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_GROUPS_USER_GROUPS);
        } else if (key.equals("layoutSet")) {
            join = CustomSQLUtil.get((String)JOIN_BY_LAYOUT_SET);
        } else if (key.equals("pageCount")) {
            join = CustomSQLUtil.get((String)JOIN_BY_PAGE_COUNT);
        } else if (key.equals("rolePermissions")) {
            join = PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6 ? CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_PERMISSIONS) : CustomSQLUtil.get((String)JOIN_BY_ROLE_PERMISSIONS);
        } else if (key.equals("type")) {
            join = CustomSQLUtil.get((String)JOIN_BY_TYPE);
        } else if (key.equals("types")) {
            List types = (List)value;
            if (!types.isEmpty()) {
                StringBundler sb = new StringBundler(types.size() * 2 + 1);
                sb.append("WHERE (");
                int i = 0;
                while (i < types.size()) {
                    sb.append("(Group_.type_ = ?) ");
                    if (i + 1 < types.size()) {
                        sb.append("OR ");
                    }
                    ++i;
                }
                sb.append(")");
                join = sb.toString();
            }
        } else if (key.equals("userGroupRole")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE);
        } else if (key.equals("usersGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS);
        }
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            join = pos != -1 ? join.substring(pos + 5, join.length()).concat(" AND ") : "";
        }
        return join;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) {
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String valueString;
                Object value;
                List values;
                Object value2;
                String key = entry.getKey();
                if (key.equals("active") || key.equals("layoutSet")) {
                    value2 = (Boolean)entry.getValue();
                    qPos.add((Boolean)value2);
                    continue;
                }
                if (key.equals("pageCount")) continue;
                if (key.equals("rolePermissions")) {
                    values = (List)entry.getValue();
                    int i = 0;
                    while (i < values.size()) {
                        value = values.get(i);
                        if (value instanceof Integer) {
                            Integer valueInteger = (Integer)value;
                            qPos.add(valueInteger);
                        } else if (value instanceof Long) {
                            Long valueLong = (Long)value;
                            qPos.add(valueLong);
                        } else if (value instanceof String) {
                            String valueString2 = (String)value;
                            qPos.add(valueString2);
                        }
                        ++i;
                    }
                    continue;
                }
                if (key.equals("types")) {
                    values = (List)entry.getValue();
                    int i = 0;
                    while (i < values.size()) {
                        value = (Integer)values.get(i);
                        qPos.add(value);
                        ++i;
                    }
                    continue;
                }
                if (key.equals("userGroupRole")) {
                    values = (List)entry.getValue();
                    Long userId = (Long)values.get(0);
                    Long roleId = (Long)values.get(1);
                    qPos.add(userId);
                    qPos.add(roleId);
                    continue;
                }
                value2 = entry.getValue();
                if (value2 instanceof Integer) {
                    Integer valueInteger = (Integer)value2;
                    if (!Validator.isNotNull((Object)valueInteger)) continue;
                    qPos.add(valueInteger);
                    continue;
                }
                if (value2 instanceof Long) {
                    Long valueLong = (Long)value2;
                    if (!Validator.isNotNull((Long)valueLong)) continue;
                    qPos.add(valueLong);
                    continue;
                }
                if (!(value2 instanceof String) || !Validator.isNotNull((String)(valueString = (String)value2))) continue;
                qPos.add(valueString);
            }
        }
    }
}

