/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.WebsiteServiceBaseImpl;
import com.liferay.portal.service.permission.CommonPermissionUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebsiteServiceImpl
extends WebsiteServiceBaseImpl {
    public Website addWebsite(String className, long classPK, String url, int typeId, boolean primary) throws PortalException, SystemException {
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)className, (long)classPK, (String)"UPDATE");
        return this.websiteLocalService.addWebsite(this.getUserId(), className, classPK, url, typeId, primary);
    }

    public void deleteWebsite(long websiteId) throws PortalException, SystemException {
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)website.getClassNameId(), (long)website.getClassPK(), (String)"UPDATE");
        this.websiteLocalService.deleteWebsite(websiteId);
    }

    public Website getWebsite(long websiteId) throws PortalException, SystemException {
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)website.getClassNameId(), (long)website.getClassPK(), (String)"VIEW");
        return website;
    }

    public List<Website> getWebsites(String className, long classPK) throws PortalException, SystemException {
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)className, (long)classPK, (String)"VIEW");
        return this.websiteLocalService.getWebsites(this.getUser().getCompanyId(), className, classPK);
    }

    public Website updateWebsite(long websiteId, String url, int typeId, boolean primary) throws PortalException, SystemException {
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)website.getClassNameId(), (long)website.getClassPK(), (String)"UPDATE");
        return this.websiteLocalService.updateWebsite(websiteId, url, typeId, primary);
    }
}

