/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.PasswordTracker;
import com.liferay.portal.model.User;
import com.liferay.portal.security.pwd.PwdEncryptor;
import com.liferay.portal.service.base.PasswordTrackerLocalServiceBaseImpl;
import java.util.Date;
import java.util.Iterator;

public class PasswordTrackerLocalServiceImpl
extends PasswordTrackerLocalServiceBaseImpl {
    public void deletePasswordTrackers(long userId) throws SystemException {
        this.passwordTrackerPersistence.removeByUserId(userId);
    }

    public boolean isSameAsCurrentPassword(long userId, String newClearTextPwd) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        String currentPwd = user.getPassword();
        if (user.isPasswordEncrypted()) {
            String newEncPwd = PwdEncryptor.encrypt(newClearTextPwd, user.getPassword());
            return currentPwd.equals(newEncPwd);
        }
        return currentPwd.equals(newClearTextPwd);
    }

    public boolean isValidPassword(long userId, String newClearTextPwd) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getPasswordPolicyByUserId(userId);
        if (!passwordPolicy.getHistory()) {
            return true;
        }
        int historyCount = 1;
        Iterator itr = this.passwordTrackerPersistence.findByUserId(userId).iterator();
        while (itr.hasNext()) {
            String newEncPwd;
            if (historyCount >= passwordPolicy.getHistoryCount()) break;
            PasswordTracker passwordTracker = (PasswordTracker)itr.next();
            String oldEncPwd = passwordTracker.getPassword();
            if (oldEncPwd.equals(newEncPwd = PwdEncryptor.encrypt(newClearTextPwd, oldEncPwd))) {
                return false;
            }
            ++historyCount;
        }
        return true;
    }

    public void trackPassword(long userId, String encPassword) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getPasswordPolicyByUserId(userId);
        if (passwordPolicy != null && passwordPolicy.isHistory()) {
            long passwordTrackerId = this.counterLocalService.increment();
            PasswordTracker passwordTracker = this.passwordTrackerPersistence.create(passwordTrackerId);
            passwordTracker.setUserId(userId);
            passwordTracker.setCreateDate(new Date());
            passwordTracker.setPassword(encPassword);
            this.passwordTrackerPersistence.update((BaseModel)passwordTracker, false);
        }
    }
}

